/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random.withoutnumber;

import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.Taxonomy;
import de.rpgframework.genericrpg.data.ComplexDataItem;
import de.rpgframework.genericrpg.data.DataItemTypeKey;
import de.rpgframework.random.withoutnumber.VariableDefinition;
import java.util.ArrayList;
import java.util.List;
import org.prelle.simplepersist.ElementList;

@DataItemTypeKey(id="tagelement")
public class StoryTagElement
extends ComplexDataItem {
    private static final System.Logger logger = System.getLogger(StoryTagElement.class.getPackageName());
    @ElementList(entry="var", type=VariableDefinition.class, inline=true)
    private List<VariableDefinition> variables = new ArrayList<VariableDefinition>();

    public void validate() {
        this.getName();
        for (VariableDefinition def : this.variables) {
            ClassificationType type = Taxonomy.getGeneric().getClassificationTypeFor(def.getName());
            if (type == null) {
                logger.log(System.Logger.Level.WARNING, "Unknown variable type ''{0}'' in {1}", new Object[]{def.getName(), this});
                continue;
            }
            Object valid = type.resolve(def.getValue());
            if (valid != null) continue;
            logger.log(System.Logger.Level.WARNING, "Unknown value ''{0}'' for variable ''{1}'' in {2}", new Object[]{def.getValue(), def.getName(), this});
        }
    }

    public List<VariableDefinition> getVariables() {
        return this.variables;
    }
}

