/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.random;

import de.rpgframework.classification.Classification;
import de.rpgframework.classification.ClassificationType;
import de.rpgframework.classification.GenericClassificationType;
import de.rpgframework.core.RoleplayingSystem;
import de.rpgframework.random.GeneratorType;
import de.rpgframework.random.RandomGenerator;
import de.rpgframework.random.RandomGeneratorRegistry;
import de.rpgframework.world.World;
import java.util.ArrayList;
import java.util.List;

public class RandomGeneratorBuilder {
    private static final System.Logger logger = System.getLogger(RandomGeneratorBuilder.class.getPackageName());
    private GeneratorType type;
    private List<Classification<?>> requirements;
    private World world;
    private RoleplayingSystem rules;
    private List<ClassificationType> optionalSupport = new ArrayList<ClassificationType>();

    public RandomGeneratorBuilder() {
        this.requirements = new ArrayList();
    }

    public RandomGeneratorBuilder thatGenerates(GeneratorType type) {
        this.type = type;
        return this;
    }

    public RandomGeneratorBuilder thatSupports(Classification<?> ... requires) {
        this.requirements = List.of(requires);
        return this;
    }

    public RandomGeneratorBuilder forSetting(World world) {
        this.world = world;
        return this;
    }

    public RandomGeneratorBuilder forRules(RoleplayingSystem rules) {
        this.rules = rules;
        this.optionalSupport.add(GenericClassificationType.GENRE);
        return this;
    }

    public RandomGeneratorBuilder optionallySupportsHints(ClassificationType ... hints) {
        for (ClassificationType hint : hints) {
            if (this.optionalSupport.contains(hint)) continue;
            this.optionalSupport.add(hint);
        }
        return this;
    }

    public RandomGeneratorBuilder optionallySupportsHints(List<ClassificationType> hints) {
        for (ClassificationType hint : hints) {
            if (this.optionalSupport.contains(hint)) continue;
            this.optionalSupport.add(hint);
        }
        return this;
    }

    public RandomGenerator build() {
        RandomGenerator generator = RandomGeneratorRegistry.findGenerator(this.type, this.requirements, this.optionalSupport);
        return generator;
    }

    public List<RandomGenerator> buildChain() {
        List<RandomGenerator> generator = RandomGeneratorRegistry.findGenerators(this.type, this.requirements, this.optionalSupport);
        ArrayList<RandomGenerator> filtered = new ArrayList<RandomGenerator>();
        ArrayList covered = new ArrayList();
        generator.forEach(gen -> {
            if (gen.getProvidedData().stream().noneMatch(type -> covered.contains(type))) {
                filtered.add((RandomGenerator)gen);
                logger.log(System.Logger.Level.DEBUG, "Generator {0} has only data types not covered yet: {1}", gen.getClass().getSimpleName(), gen.getProvidedData());
                covered.addAll(gen.getProvidedData());
            }
        });
        return filtered;
    }
}

