/*
 * Decompiled with CFR 0.152.
 */
package de.rpgframework.foundry;

import de.rpgframework.foundry.Dependency;
import de.rpgframework.foundry.Language;
import de.rpgframework.foundry.Pack;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class Module {
    public transient ByteArrayOutputStream fos;
    private String name;
    private String title;
    private String description;
    private String author = "RPGFramework";
    private String version;
    private List<String> systems;
    private String minimumCoreVersion;
    private String compatibleCoreVersion;
    private List<Pack> packs = new ArrayList<Pack>();
    private List<Dependency> dependencies;
    private List<Language> languages = new ArrayList<Language>();
    private String socket;
    private String initiative;
    private String gridDistance;
    private String gridUnits;
    private String primaryTokenAttribute;
    private String secondaryTokenAttribute;
    private String url;
    private String manifest;
    private String download;

    private Language getOrCreateLanguage(String key) {
        for (Language lang : this.languages) {
            if (!lang.getLang().equalsIgnoreCase(key)) continue;
            return lang;
        }
        Language lang = new Language();
        lang.setLang(key);
        lang.setName(this.name + "-translation-" + key);
        lang.setPath("lang/" + this.name + "_" + key + ".json");
        this.languages.add(lang);
        return lang;
    }

    public void addTranslation(String lang, String key, String value) {
        Language tmp = this.getOrCreateLanguage(lang);
        tmp.addTranslation(key, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMinimumCoreVersion() {
        return this.minimumCoreVersion;
    }

    public void setMinimumCoreVersion(String minimumCoreVersion) {
        this.minimumCoreVersion = minimumCoreVersion;
    }

    public String getCompatibleCoreVersion() {
        return this.compatibleCoreVersion;
    }

    public void setCompatibleCoreVersion(String compatibleCoreVersion) {
        this.compatibleCoreVersion = compatibleCoreVersion;
    }

    public List<Pack> getPacks() {
        return this.packs;
    }

    public void setPacks(List<Pack> packs) {
        this.packs = packs;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getManifest() {
        return this.manifest;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public String getDownload() {
        return this.download;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<Language> languages) {
        this.languages = languages;
    }
}

