/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.upconversion.MathMLUpConverter;
import uk.ac.ed.ph.snuggletex.upconversion.UpConvertingPostProcessor;
import uk.ac.ed.ph.snuggletex.upconversion.internal.UpConversionPackageDefinitions;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;

public final class UpConversionExampleFragmentServlet
extends BaseServlet {
    private static final long serialVersionUID = 4376587500238353176L;
    private static Logger logger = LoggerFactory.getLogger(UpConversionExampleFragmentServlet.class);
    private static final String DISPLAY_XSLT_LOCATION = "classpath:/upconversion-example-fragment.xsl";
    private static final String DEFAULT_UPCONVERSION_OPTIONS = "\\assumeSymbol{e}{exponentialNumber}\n\\assumeSymbol{f}{function}\n\\assumeSymbol{f_n}{function}\n\\assumeSymbol{g}{function}\n\\assumeSymbol{i}{imaginaryNumber}\n\\assumeSymbol{\\pi}{constantPi}\n\\assumeSymbol{\\gamma}{eulerGamma}";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawInputLaTeX = request.getParameter("input");
        if (rawInputLaTeX == null) {
            response.sendError(400, "No input provided");
            return;
        }
        String inputLaTeX = rawInputLaTeX.replaceAll("\\s+", " ");
        if (inputLaTeX.contains("%")) {
            inputLaTeX = URLDecoder.decode(inputLaTeX, "UTF-8");
        }
        SnuggleEngine engine = this.createSnuggleEngine();
        engine.addPackage(UpConversionPackageDefinitions.getPackage());
        SnuggleSession session = engine.createSession();
        if (inputLaTeX.endsWith("$") || inputLaTeX.endsWith("\\]") || inputLaTeX.endsWith("\\)")) {
            session.parseInput(new SnuggleInput(inputLaTeX, "Query Input"));
        } else {
            session.parseInput(new SnuggleInput(DEFAULT_UPCONVERSION_OPTIONS, "Default Assumptions Input"));
            session.parseInput(new SnuggleInput("\\[ " + inputLaTeX + " \\]", "Query Input"));
        }
        Document resultDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element resultRoot = resultDocument.createElement("root");
        resultDocument.appendChild(resultRoot);
        DOMOutputOptions domOptions = new DOMOutputOptions();
        domOptions.setMathVariantMapping(true);
        domOptions.setAddingMathSourceAnnotations(true);
        domOptions.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.NO_OUTPUT);
        session.buildDOMSubtree(resultRoot, domOptions);
        NodeList resultNodeList = resultRoot.getChildNodes();
        List errors = session.getErrors();
        Element mathMLElement = null;
        String parallelMathML = null;
        String pMathMLInitial = null;
        String pMathMLUpConverted = null;
        String cMathML = null;
        String maximaInput = null;
        ArrayList<Element> parsingErrors = null;
        UpConvertingPostProcessor upConvertingPostProcessor = new UpConvertingPostProcessor();
        SerializationSpecifier sourceSerializationOptions = this.createMathMLSourceSerializationOptions();
        boolean badInput = false;
        if (!errors.isEmpty()) {
            parsingErrors = new ArrayList<Element>();
            for (InputError error : errors) {
                parsingErrors.add(MessageFormatter.formatErrorAsXML((Document)resultDocument, (InputError)error, (boolean)true));
            }
        } else {
            mathMLElement = this.extractMathMLElement(resultNodeList, true);
            if (mathMLElement == null) {
                badInput = true;
            }
        }
        if (mathMLElement != null) {
            pMathMLInitial = MathMLUtilities.serializeElement((Element)mathMLElement, (SerializationSpecifier)sourceSerializationOptions);
            MathMLUpConverter upConverter = new MathMLUpConverter(this.getStylesheetCache());
            Document upConvertedMathDocument = upConverter.upConvertSnuggleTeXMathML(mathMLElement.getOwnerDocument(), upConvertingPostProcessor.getUpconversionOptions());
            mathMLElement = this.extractMathMLElement(upConvertedMathDocument.getDocumentElement().getChildNodes(), false);
            parallelMathML = MathMLUtilities.serializeElement((Element)mathMLElement, (SerializationSpecifier)sourceSerializationOptions);
            pMathMLUpConverted = MathMLUtilities.serializeDocument((Document)MathMLUtilities.isolateFirstSemanticsBranch((Element)mathMLElement), (SerializationSpecifier)sourceSerializationOptions);
            Document cMathMLDocument = MathMLUtilities.isolateAnnotationXML((Element)mathMLElement, (String)"MathML-Content");
            cMathML = cMathMLDocument != null ? MathMLUtilities.serializeDocument((Document)cMathMLDocument, (SerializationSpecifier)sourceSerializationOptions) : null;
            maximaInput = MathMLUtilities.extractAnnotationString((Element)mathMLElement, (String)"Maxima");
        }
        if (!errors.isEmpty()) {
            logger.error("Input: {}", (Object)inputLaTeX);
            logger.error("Final MathML: {}", parallelMathML);
            logger.error("Error count: {}", (Object)errors.size());
            for (InputError error : errors) {
                logger.error("Error: " + MessageFormatter.formatErrorAsString((InputError)error));
            }
        }
        WebPageOutputOptions webOptions = WebPageOutputOptionsTemplates.createWebPageOptions((WebPageOutputOptions.WebPageType)WebPageOutputOptions.WebPageType.PROCESSED_HTML);
        webOptions.setDoctypePublic("-//W3C//DTD XHTML 1.0 Strict//EN");
        webOptions.setDoctypeSystem("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        webOptions.setMathVariantMapping(true);
        webOptions.setAddingMathSourceAnnotations(true);
        webOptions.setIndenting(true);
        webOptions.setIncludingStyleElement(false);
        Transformer viewStylesheet = this.getStylesheet(request, DISPLAY_XSLT_LOCATION);
        viewStylesheet.setParameter("latex-input", inputLaTeX);
        viewStylesheet.setParameter("is-bad-input", badInput);
        viewStylesheet.setParameter("parsing-errors", parsingErrors);
        viewStylesheet.setParameter("parallel-mathml", parallelMathML);
        viewStylesheet.setParameter("pmathml-initial", pMathMLInitial);
        viewStylesheet.setParameter("pmathml-upconverted", pMathMLUpConverted);
        viewStylesheet.setParameter("cmathml", cMathML);
        viewStylesheet.setParameter("maxima-input", maximaInput);
        webOptions.setStylesheets(new Transformer[]{viewStylesheet});
        try {
            session.writeWebPage(webOptions, (Object)response, (OutputStream)response.getOutputStream(), SnuggleSession.EndOutputAction.FLUSH);
        }
        catch (Exception e) {
            throw new ServletException("Unexpected Exception", (Throwable)e);
        }
    }
}

