/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.DOMPostProcessor;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.upconversion.MathMLUpConverter;
import uk.ac.ed.ph.snuggletex.upconversion.UpConvertingPostProcessor;
import uk.ac.ed.ph.snuggletex.upconversion.internal.UpConversionPackageDefinitions;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;

public final class UpConversionDemoServlet
extends BaseServlet {
    private static final long serialVersionUID = 4376587500238353176L;
    private static Logger logger = LoggerFactory.getLogger(UpConversionDemoServlet.class);
    private static final String DEFAULT_INPUT = "\\frac{2f(x)-e^x}{\\sin xy^2(x-2)}";
    private static final String DEFAULT_UPCONVERSION_OPTIONS = "\\assumeSymbol{e}{exponentialNumber}\n\\assumeSymbol{f}{function}\n\\assumeSymbol{f_n}{function}\n\\assumeSymbol{g}{function}\n\\assumeSymbol{i}{imaginaryNumber}\n\\assumeSymbol{\\pi}{constantPi}\n\\assumeSymbol{\\gamma}{eulerGamma}\n\\setUpConversionOption{addOptionsAnnotation}{true}";
    private static final String DISPLAY_XSLT_LOCATION = "classpath:/upconversion-demo.xsl";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebPageOutputOptions webOptions;
        boolean mathMLCapable;
        String rawInputLaTeX = request.getParameter("input");
        String inputLaTeX = rawInputLaTeX != null ? rawInputLaTeX.replaceAll("\\s+", " ") : DEFAULT_INPUT;
        String rawUpConversionOptions = request.getParameter("upConversionOptions");
        String upConversionOptions = rawUpConversionOptions != null ? rawUpConversionOptions : DEFAULT_UPCONVERSION_OPTIONS;
        boolean hasChangedUpConversionOptions = rawUpConversionOptions != null && !rawUpConversionOptions.equals(DEFAULT_UPCONVERSION_OPTIONS);
        SnuggleEngine engine = this.createSnuggleEngine();
        engine.addPackage(UpConversionPackageDefinitions.getPackage());
        SnuggleSession session = engine.createSession();
        session.parseInput(new SnuggleInput(upConversionOptions, "Assumptions Input"));
        session.parseInput(new SnuggleInput("\\[ " + inputLaTeX + " \\]", "Math Input"));
        Document resultDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element resultRoot = resultDocument.createElement("root");
        resultDocument.appendChild(resultRoot);
        DOMOutputOptions domOptions = new DOMOutputOptions();
        domOptions.setMathVariantMapping(true);
        domOptions.setAddingMathSourceAnnotations(true);
        domOptions.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.NO_OUTPUT);
        session.buildDOMSubtree(resultRoot, domOptions);
        NodeList resultNodeList = resultRoot.getChildNodes();
        List errors = session.getErrors();
        Element mathMLElement = null;
        String parallelMathML = null;
        String pMathMLInitial = null;
        String pMathMLUpConverted = null;
        String cMathML = null;
        String maximaInput = null;
        ArrayList<Element> parsingErrors = null;
        UpConvertingPostProcessor upConvertingPostProcessor = new UpConvertingPostProcessor();
        SerializationSpecifier sourceSerializationOptions = this.createMathMLSourceSerializationOptions();
        boolean badInput = false;
        if (!errors.isEmpty()) {
            parsingErrors = new ArrayList<Element>();
            for (InputError error : errors) {
                parsingErrors.add(MessageFormatter.formatErrorAsXML((Document)resultDocument, (InputError)error, (boolean)true));
            }
        } else {
            mathMLElement = this.extractMathMLElement(resultNodeList, true);
            if (mathMLElement == null) {
                badInput = true;
            }
        }
        if (mathMLElement != null) {
            pMathMLInitial = MathMLUtilities.serializeElement((Element)mathMLElement, (SerializationSpecifier)sourceSerializationOptions);
            MathMLUpConverter upConverter = new MathMLUpConverter(this.getStylesheetCache());
            Document upConvertedMathDocument = upConverter.upConvertSnuggleTeXMathML(mathMLElement.getOwnerDocument(), upConvertingPostProcessor.getUpconversionOptions());
            mathMLElement = this.extractMathMLElement(upConvertedMathDocument.getDocumentElement().getChildNodes(), false);
            parallelMathML = MathMLUtilities.serializeElement((Element)mathMLElement, (SerializationSpecifier)sourceSerializationOptions);
            pMathMLUpConverted = MathMLUtilities.serializeDocument((Document)MathMLUtilities.isolateFirstSemanticsBranch((Element)mathMLElement), (SerializationSpecifier)sourceSerializationOptions);
            Document cMathMLDocument = MathMLUtilities.isolateAnnotationXML((Element)mathMLElement, (String)"MathML-Content");
            cMathML = cMathMLDocument != null ? MathMLUtilities.serializeDocument((Document)cMathMLDocument, (SerializationSpecifier)sourceSerializationOptions) : null;
            maximaInput = MathMLUtilities.extractAnnotationString((Element)mathMLElement, (String)"Maxima");
        }
        if (rawInputLaTeX != null) {
            if (badInput || !errors.isEmpty()) {
                if (hasChangedUpConversionOptions) {
                    logger.warn("Up-Conversion Options: {}", (Object)upConversionOptions);
                }
                logger.warn("Input: {}", (Object)inputLaTeX);
                logger.warn("Final MathML: {}", parallelMathML);
                logger.warn("Error count: {}", (Object)errors.size());
                for (InputError error : errors) {
                    logger.warn("Error: " + MessageFormatter.formatErrorAsString((InputError)error));
                }
            } else {
                if (hasChangedUpConversionOptions) {
                    logger.info("Up-Conversion Options: {}", (Object)upConversionOptions);
                }
                logger.info("Input: {}", (Object)inputLaTeX);
                logger.info("Final MathML: {}", parallelMathML);
            }
        }
        boolean bl = mathMLCapable = (webOptions = this.chooseBestBaseWebPageOutputOptions(request)).getWebPageType() != WebPageOutputOptions.WebPageType.PROCESSED_HTML;
        if (mathMLCapable) {
            webOptions.setDOMPostProcessors(new DOMPostProcessor[]{upConvertingPostProcessor});
        }
        Transformer viewStylesheet = this.getStylesheet(request, DISPLAY_XSLT_LOCATION);
        viewStylesheet.setParameter("is-mathml-capable", mathMLCapable);
        viewStylesheet.setParameter("is-internet-explorer", this.isInternetExplorer(request));
        viewStylesheet.setParameter("latex-input", inputLaTeX);
        viewStylesheet.setParameter("upconversion-options", upConversionOptions);
        viewStylesheet.setParameter("is-bad-input", badInput);
        viewStylesheet.setParameter("parsing-errors", parsingErrors);
        viewStylesheet.setParameter("parallel-mathml", parallelMathML);
        viewStylesheet.setParameter("pmathml-initial", pMathMLInitial);
        viewStylesheet.setParameter("pmathml-upconverted", pMathMLUpConverted);
        viewStylesheet.setParameter("cmathml", cMathML);
        viewStylesheet.setParameter("maxima-input", maximaInput);
        webOptions.setStylesheets(new Transformer[]{viewStylesheet});
        try {
            session.writeWebPage(webOptions, (Object)response, (OutputStream)response.getOutputStream(), SnuggleSession.EndOutputAction.FLUSH);
        }
        catch (Exception e) {
            throw new ServletException("Unexpected Exception", (Throwable)e);
        }
    }
}

