/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.webapp.WebUtilities;

public final class RedirectionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RedirectionFilter.class);
    private final LinkedHashMap<Pattern, String> redirectionMap = new LinkedHashMap();

    public void init(FilterConfig filterConfig) {
        String redirectionData = filterConfig.getInitParameter("redirections");
        if (redirectionData != null) {
            this.redirectionMap.clear();
            String[] fields = redirectionData.split("\\s+");
            int i = 0;
            while (i < fields.length) {
                Pattern pattern = Pattern.compile(fields[i++]);
                String target = fields[i++];
                logger.info("Registering redirect " + pattern + " => " + target);
                this.redirectionMap.put(pattern, target);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestUrl = WebUtilities.getWithinContextRequestUrl((HttpServletRequest)httpRequest);
        for (Map.Entry mapEntry : this.redirectionMap.entrySet()) {
            Pattern matchPattern = (Pattern)mapEntry.getKey();
            String replacement = (String)mapEntry.getValue();
            Matcher matcher = matchPattern.matcher(requestUrl);
            if (!matcher.matches()) continue;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendRedirect(httpRequest.getContextPath() + matcher.replaceFirst(replacement));
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

