/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.utilities.MathMLPostProcessor;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;

public final class MathMLToImageLinkPostProcessor
extends MathMLPostProcessor {
    private final String contextPath;

    public MathMLToImageLinkPostProcessor(String contextPath) {
        this.contextPath = contextPath;
    }

    protected void handleMathMLIsland(Element inputMathIsland, Document outputDocument, Node outputParentNode, int mathmlCounter) {
        String snuggleInput = MathMLUtilities.extractAnnotationString((Element)inputMathIsland, (String)"SnuggleTeX");
        if (snuggleInput == null) {
            throw new SnuggleRuntimeException("Expected to find SnuggleTeX annotation inside MathML - fix this process!");
        }
        boolean isBlock = "block".equals(inputMathIsland.getAttribute("display"));
        Element replacement = outputDocument.createElementNS("http://www.w3.org/1999/xhtml", isBlock ? "div" : "span");
        replacement.setAttribute("class", "mathml-math");
        Element image = outputDocument.createElementNS("http://www.w3.org/1999/xhtml", "img");
        try {
            image.setAttribute("src", this.contextPath + "/MathInputToImage.png?input=" + URLEncoder.encode(snuggleInput, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SnuggleRuntimeException("Unexpected Exception", (Throwable)e);
        }
        replacement.appendChild(image);
        outputParentNode.appendChild(replacement);
    }
}

