/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.jeuclid.JEuclidUtilities;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;
import uk.ac.ed.ph.snuggletex.webapp.MathInputToImageServlet;

public final class MathInputToImageServlet
extends BaseServlet {
    private static final long serialVersionUID = 2349962200011540329L;
    private static final Logger logger = LoggerFactory.getLogger(MathInputToImageServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String inputLaTeX = request.getParameter("input");
        if (inputLaTeX == null || inputLaTeX.trim().length() == 0) {
            response.sendError(400, "Empty input");
            return;
        }
        SnuggleEngine engine = this.createSnuggleEngine();
        SnuggleSession session = engine.createSession();
        SnuggleInput input = new SnuggleInput(inputLaTeX, "Form Input");
        session.parseInput(input);
        File tempFile = File.createTempFile("mathimage-", "png");
        ImageSavingCallback callback = new ImageSavingCallback(tempFile);
        try {
            WebPageOutputOptions options = JEuclidUtilities.createWebPageOptions((boolean)false, (MathMLImageSavingCallback)callback);
            options.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.NO_OUTPUT);
            options.setMathVariantMapping(true);
            options.setAddingMathSourceAnnotations(false);
            options.setIndenting(false);
            session.createWebPage(options);
            List errors = session.getErrors();
            if (!errors.isEmpty()) {
                logger.warn("Bad input: {}", (Object)inputLaTeX);
                logger.warn("Error count: {}", (Object)errors.size());
                for (InputError error : errors) {
                    logger.warn("Error: " + MessageFormatter.formatErrorAsString((InputError)error));
                }
                response.sendError(400, "Bad LaTeX Input");
            } else if (callback.getFailure() != null) {
                logger.warn("Could not generate image for input: " + inputLaTeX, callback.getFailure());
                response.sendError(400, "Could not generate image for this input");
            } else {
                response.setContentType("image/png");
                response.setContentLength((int)tempFile.length());
                IOUtilities.transfer((InputStream)new FileInputStream(tempFile), (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
            }
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }
}

