/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;

public final class MathInputDemoServlet
extends BaseServlet {
    private static final long serialVersionUID = 6381049839030645425L;
    private static Logger logger = LoggerFactory.getLogger(MathInputDemoServlet.class);
    private static final String DEFAULT_INPUT = "1+x";
    private static final String DISPLAY_XSLT_LOCATION = "classpath:/math-input-demo.xsl";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebPageOutputOptions webOptions;
        String rawInputLaTeX = request.getParameter("input");
        String inputLaTeX = rawInputLaTeX != null ? rawInputLaTeX.replaceAll("\\s+", " ") : DEFAULT_INPUT;
        SnuggleEngine engine = this.createSnuggleEngine();
        SnuggleSession session = engine.createSession();
        SnuggleInput input = new SnuggleInput("\\[ " + inputLaTeX + " \\]", "Form Input");
        session.parseInput(input);
        Document resultDocument = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        Element resultRoot = resultDocument.createElement("root");
        resultDocument.appendChild(resultRoot);
        DOMOutputOptions domOptions = new DOMOutputOptions();
        domOptions.setMathVariantMapping(true);
        domOptions.setAddingMathSourceAnnotations(true);
        domOptions.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.NO_OUTPUT);
        session.buildDOMSubtree(resultRoot, domOptions);
        NodeList resultNodeList = resultRoot.getChildNodes();
        List errors = session.getErrors();
        Element resultMathMLElement = null;
        String resultMathMLSource = null;
        ArrayList<Element> parsingErrors = null;
        boolean badInput = false;
        if (!errors.isEmpty()) {
            parsingErrors = new ArrayList<Element>();
            for (InputError error : errors) {
                parsingErrors.add(MessageFormatter.formatErrorAsXML((Document)resultDocument, (InputError)error, (boolean)true));
            }
        } else if (resultNodeList.getLength() == 1 && MathMLUtilities.isMathMLElement((Node)resultNodeList.item(0), (String)"math")) {
            resultMathMLElement = (Element)resultNodeList.item(0);
            resultMathMLSource = MathMLUtilities.serializeElement((Element)resultMathMLElement, (SerializationSpecifier)this.createMathMLSourceSerializationOptions(), (StylesheetManager)this.getStylesheetManager());
        } else {
            badInput = true;
        }
        if (rawInputLaTeX != null) {
            if (errors.isEmpty()) {
                logger.info("Input: {}", (Object)inputLaTeX);
                logger.info("Resulting MathML: {}", resultMathMLSource);
            } else {
                logger.warn("Input: {}", (Object)inputLaTeX);
                logger.warn("Resulting MathML: {}", resultMathMLSource);
                logger.warn("Error count: {}", (Object)errors.size());
                for (InputError error : errors) {
                    logger.warn("Error: " + MessageFormatter.formatErrorAsString((InputError)error));
                }
            }
        }
        boolean mathMLCapable = (webOptions = this.chooseBestBaseWebPageOutputOptions(request)).getWebPageType() != WebPageOutputOptions.WebPageType.PROCESSED_HTML;
        Transformer viewStylesheet = this.getStylesheet(request, DISPLAY_XSLT_LOCATION);
        viewStylesheet.setParameter("is-mathml-capable", mathMLCapable);
        viewStylesheet.setParameter("is-internet-explorer", this.isInternetExplorer(request));
        viewStylesheet.setParameter("latex-input", inputLaTeX);
        viewStylesheet.setParameter("is-bad-input", badInput);
        viewStylesheet.setParameter("parsing-errors", parsingErrors);
        viewStylesheet.setParameter("result-mathml-source", resultMathMLSource);
        viewStylesheet.setParameter("result-mathml-element", resultMathMLElement);
        webOptions.setStylesheets(new Transformer[]{viewStylesheet});
        try {
            session.writeWebPage(webOptions, (Object)response, (OutputStream)response.getOutputStream(), SnuggleSession.EndOutputAction.FLUSH);
        }
        catch (Exception e) {
            throw new ServletException("Unexpected Exception", (Throwable)e);
        }
    }
}

