/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;

public final class FullLaTeXInputDemoServlet
extends BaseServlet {
    private static final long serialVersionUID = 4376587500238353176L;
    private Logger logger = LoggerFactory.getLogger(FullLaTeXInputDemoServlet.class);
    private static final String DISPLAY_XSLT_LOCATION = "classpath:/full-latex-input-demo.xsl";
    private static final String DEFAULT_INPUT_LOCATION = "/WEB-INF/full-latex-input-demo-default.tex";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String rawInputLaTeX = request.getParameter("input");
        String inputLaTeX = rawInputLaTeX != null ? rawInputLaTeX.replaceAll("(\r\n|\r|\n)", "\n") : this.readDefaultInput();
        SnuggleEngine engine = this.createSnuggleEngine();
        SnuggleSession session = engine.createSession();
        SnuggleInput input = new SnuggleInput(inputLaTeX, "Form Input");
        session.parseInput(input);
        WebPageOutputOptions webOutputOptions = this.chooseBestBaseWebPageOutputOptions(request);
        webOutputOptions.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.XHTML);
        if (rawInputLaTeX != null) {
            String xmlString = session.buildXMLString();
            List errors = session.getErrors();
            if (errors.isEmpty()) {
                this.logger.info("Input:  {}", (Object)inputLaTeX);
                this.logger.info("Output: {}", (Object)xmlString);
            } else {
                this.logger.warn("Input:  {}", (Object)inputLaTeX);
                this.logger.warn("Output: {}", (Object)xmlString);
                this.logger.warn("Errors: #{}", (Object)errors.size());
                for (InputError error : errors) {
                    this.logger.warn("Error:  " + MessageFormatter.formatErrorAsString((InputError)error));
                }
            }
        }
        Transformer viewStylesheet = this.getStylesheet(request, DISPLAY_XSLT_LOCATION);
        viewStylesheet.setParameter("is-mathml-capable", this.isMathMLCapable(request));
        viewStylesheet.setParameter("is-internet-explorer", this.isInternetExplorer(request));
        viewStylesheet.setParameter("latex-input", inputLaTeX);
        webOutputOptions.setStylesheets(new Transformer[]{viewStylesheet});
        try {
            session.writeWebPage(webOutputOptions, (Object)response, (OutputStream)response.getOutputStream(), SnuggleSession.EndOutputAction.FLUSH);
        }
        catch (Exception e) {
            throw new ServletException("Unexpected Exception", (Throwable)e);
        }
    }

    private String readDefaultInput() throws ServletException, IOException {
        InputStream resourceStream = this.ensureReadResource(DEFAULT_INPUT_LOCATION);
        return IOUtilities.readUnicodeStream((InputStream)resourceStream);
    }
}

