/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.ed.ph.snuggletex.ErrorCode;
import uk.ac.ed.ph.snuggletex.ErrorGroup;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.upconversion.internal.UpConversionPackageDefinitions;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.utilities.SnuggleUtilities;

public final class ErrorCodeDocumentBuilder {
    private final File outputFile;

    public ErrorCodeDocumentBuilder(File outputFile) {
        this.outputFile = outputFile;
    }

    public void run() throws IOException {
        IOUtilities.ensureFileCreated((File)this.outputFile);
        PrintWriter outputWriter = new PrintWriter(this.outputFile);
        outputWriter.println("\\pageId{errorCodes}");
        outputWriter.println("\n(In the tables below, \\{0\\} et\\ al\\ are placeholders for details specific to each error instance that are substituted in when formatting error messages)");
        this.doSnugglePackage(outputWriter, CorePackageDefinitions.getPackage());
        this.doSnugglePackage(outputWriter, UpConversionPackageDefinitions.getPackage());
        outputWriter.close();
    }

    public void doSnugglePackage(PrintWriter outputWriter, SnugglePackage snugglePackage) {
        outputWriter.println("\n\\subsection*{Package: " + SnuggleUtilities.quoteTextForInput((String)snugglePackage.getName()) + "}\n");
        for (ErrorGroup errorGroup : snugglePackage.getErrorGroups()) {
            this.doErrorGroup(outputWriter, errorGroup);
        }
    }

    public void doErrorGroup(PrintWriter outputWriter, ErrorGroup errorGroup) {
        outputWriter.println("\n\\subsubsection*{Error Group: " + SnuggleUtilities.quoteTextForInput((String)MessageFormatter.formatErrorGroup((ErrorGroup)errorGroup)) + "}");
        outputWriter.println("\\begin{tabular}{|c|l|}\n\\hline");
        for (ErrorCode errorCode : errorGroup.getPackage().getErrorCodes(errorGroup)) {
            String codeName = errorCode.getName();
            outputWriter.println("\\anchor{" + codeName + "}\\verb|" + codeName + "| & " + SnuggleUtilities.quoteTextForInput((String)errorCode.getErrorGroup().getPackage().getErrorMessageBundle().getString(codeName)) + " \\\\ \\hline");
        }
        outputWriter.println("\\end{tabular}");
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Please supply an output file");
            System.exit(1);
        }
        new ErrorCodeDocumentBuilder(new File(args[0])).run();
    }
}

