/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.jeuclid.JEuclidUtilities;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;
import uk.ac.ed.ph.snuggletex.webapp.DocumentationServlet;

public final class DocumentationServlet
extends BaseServlet {
    private static final long serialVersionUID = -4091098938512353014L;
    static final Logger logger = LoggerFactory.getLogger(DocumentationServlet.class);
    private static final String CACHING_PARAM = "caching";
    private static final String FORMAT_OUTPUT_XSLT_URI = "classpath:/format-output.xsl";
    private static final String MACROS_RESOURCE_LOCATION = "/WEB-INF/macros.tex";
    private static final String TEX_SOURCE_BASE_RESOURCE = "/WEB-INF/docs";
    private final Map<String, String> extensionToContentTypeMap;
    private final Map<String, WebPageOutputOptions.WebPageType> extensionToWebPageTypeMap = new HashMap();
    private boolean caching;
    private File baseDirectory;

    public void init() throws ServletException {
        if (this.baseDirectory == null) {
            try {
                this.baseDirectory = File.createTempFile("snuggletex-", ".dir");
            }
            catch (IOException e) {
                throw new ServletException("Could not create initial tempfile for storing documentation", (Throwable)e);
            }
            if (!this.baseDirectory.delete()) {
                throw new ServletException("Could not delete tempfile at " + this.baseDirectory + " for re-creating as a directory");
            }
            if (!this.baseDirectory.mkdir()) {
                throw new ServletException("Could not create base directory at " + this.baseDirectory + " for storing documentation");
            }
            logger.info("Set base directory for documentation as {}", (Object)this.baseDirectory);
        }
        this.caching = "true".equals(this.getServletConfig().getInitParameter(CACHING_PARAM));
    }

    public DocumentationServlet() {
        this.extensionToWebPageTypeMap.put("xhtml", WebPageOutputOptions.WebPageType.MOZILLA);
        this.extensionToWebPageTypeMap.put("xml", WebPageOutputOptions.WebPageType.UNIVERSAL_STYLESHEET);
        this.extensionToWebPageTypeMap.put("cxml", WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML);
        this.extensionToWebPageTypeMap.put("htm", WebPageOutputOptions.WebPageType.MATHPLAYER_HTML);
        this.extensionToWebPageTypeMap.put("html", WebPageOutputOptions.WebPageType.PROCESSED_HTML);
        this.extensionToContentTypeMap = new HashMap();
        this.extensionToContentTypeMap.put("xhtml", "application/xhtml+xml");
        this.extensionToContentTypeMap.put("xml", "application/xhtml+xml");
        this.extensionToContentTypeMap.put("cxml", "application/xhtml+xml");
        this.extensionToContentTypeMap.put("htm", "text/html");
        this.extensionToContentTypeMap.put("html", "text/html");
        this.extensionToContentTypeMap.put("mhtml", "text/html");
        this.extensionToContentTypeMap.put("tex", "application/x-latex");
        this.extensionToContentTypeMap.put("png", "image/png");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourcePath = request.getPathInfo();
        int lastDotPosition = resourcePath.lastIndexOf(".");
        if (lastDotPosition == -1) {
            response.sendError(404, "Could not locate '.' in resourcePath " + resourcePath);
            return;
        }
        String resourceBaseName = resourcePath.substring(0, lastDotPosition);
        String extension = resourcePath.substring(lastDotPosition + 1);
        File resourceFile = this.mapResourcePath(resourcePath);
        String contentType = (String)this.extensionToContentTypeMap.get(extension);
        if (contentType == null) {
            response.sendError(404, "Unsupported documentation resource extension " + extension);
            return;
        }
        if (!("png".equals(extension) || resourceFile.exists() && this.caching || (resourceFile = this.generateResource(request, resourcePath, resourceBaseName, extension)) != null)) {
            response.sendError(404, "Documentation page does not exist");
            return;
        }
        response.setContentType(contentType);
        response.setContentLength((int)resourceFile.length());
        IOUtilities.transfer((InputStream)new FileInputStream(resourceFile), (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
    }

    private File mapResourcePath(String resourcePath) {
        return new File(this.baseDirectory + File.separator + resourcePath.replace("/", File.separator));
    }

    private File generateResource(HttpServletRequest request, String resourcePath, String resourceBaseName, String extension) throws ServletException, IOException {
        logger.info("Generating Resource at {}", (Object)resourcePath);
        String texSourceName = resourceBaseName + ".tex";
        String texSourceResourcePath = TEX_SOURCE_BASE_RESOURCE + texSourceName;
        InputStream texSourceStream = this.getServletContext().getResourceAsStream(texSourceResourcePath);
        if (texSourceStream == null) {
            logger.info("Could not locate source resource at {}", (Object)texSourceResourcePath);
            return null;
        }
        File resultFile = null;
        if (extension.equals("tex")) {
            resultFile = IOUtilities.ensureFileCreated((File)this.mapResourcePath(resourcePath));
            IOUtilities.transfer((InputStream)texSourceStream, (OutputStream)new FileOutputStream(resultFile));
        } else {
            if (extension.equals("png")) {
                throw new SnuggleLogicException("PNG generation is done as a side-effect so shouldn't have been requested directly");
            }
            WebPageOutputOptions.WebPageType webPageType = (WebPageOutputOptions.WebPageType)this.extensionToWebPageTypeMap.get(extension);
            if (webPageType == null) {
                logger.info("Resource extension {} not understood", (Object)extension);
                return null;
            }
            String imageOutputDirectortyResourcePath = resourceBaseName;
            String imageOutputBaseUrl = request.getContextPath() + request.getServletPath() + resourceBaseName;
            resultFile = this.generateSnuggledFile(request, texSourceStream, texSourceResourcePath, webPageType, resourcePath, imageOutputDirectortyResourcePath, imageOutputBaseUrl);
        }
        return resultFile;
    }

    private File generateSnuggledFile(HttpServletRequest request, InputStream texSourceStream, String texSourceResourcePath, WebPageOutputOptions.WebPageType webPageType, String outputResourcePath, String imageOutputDirectoryResourcePath, String imageOutputBaseURL) throws ServletException, IOException {
        InputStream macrosResource = this.ensureReadResource(MACROS_RESOURCE_LOCATION);
        SnuggleEngine engine = this.createSnuggleEngine();
        SnuggleSession session = engine.createSession();
        session.parseInput(new SnuggleInput(macrosResource, "Web resource at /WEB-INF/macros.tex"));
        session.parseInput(new SnuggleInput(texSourceStream, "Web resource at " + texSourceResourcePath));
        WebPageOutputOptions options = WebPageOutputOptionsTemplates.createWebPageOptions((WebPageOutputOptions.WebPageType)webPageType);
        options.setErrorOutputOptions(DOMOutputOptions.ErrorOutputOptions.XHTML);
        options.setMathVariantMapping(true);
        options.setAddingMathSourceAnnotations(true);
        options.setIndenting(true);
        options.setIncludingStyleElement(false);
        if (webPageType == WebPageOutputOptions.WebPageType.PROCESSED_HTML) {
            File imageOutputDirectory = IOUtilities.ensureDirectoryCreated((File)this.mapResourcePath(imageOutputDirectoryResourcePath));
            ImageSavingCallback callback = new ImageSavingCallback(this, imageOutputDirectory, imageOutputBaseURL);
            options.setDoctypePublic("-//W3C//DTD XHTML 1.0 Strict//EN");
            options.setDoctypeSystem("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            options.setSerializationMethod(SerializationMethod.XHTML);
            JEuclidUtilities.setupJEuclidPostProcessors((DOMOutputOptions)options, (boolean)true, (MathMLImageSavingCallback)callback);
        } else if (webPageType == WebPageOutputOptions.WebPageType.UNIVERSAL_STYLESHEET) {
            options.setClientSideXSLTStylesheetURLs(new String[]{request.getContextPath() + "/includes/pmathml.xsl"});
        }
        Transformer stylesheet = this.getStylesheet(request, FORMAT_OUTPUT_XSLT_URI);
        stylesheet.setParameter("page-type", webPageType != WebPageOutputOptions.WebPageType.PROCESSED_HTML ? webPageType.name() : null);
        options.setStylesheets(new Transformer[]{stylesheet});
        File outputFile = IOUtilities.ensureFileCreated((File)this.mapResourcePath(outputResourcePath));
        boolean success = session.writeWebPage(options, (OutputStream)new FileOutputStream(outputFile));
        List errors = session.getErrors();
        if (!errors.isEmpty()) {
            logger.warn("Errors occurred generating resource {}", (Object)outputResourcePath);
            for (InputError error : errors) {
                logger.warn("Error: " + MessageFormatter.formatErrorAsString((InputError)error));
            }
        }
        if (!success) {
            logger.warn("Failed to generate resulting resource at " + outputFile);
        }
        return outputFile;
    }
}

