/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ed.ph.snuggletex.utilities.SaxonTransformerFactoryChooser;
import uk.ac.ed.ph.snuggletex.utilities.SimpleStylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.utilities.TransformerFactoryChooser;

public final class ContextInitialiser
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ContextInitialiser.class);
    public static final String SNUGGLETEX_VERSION_PROPERTY_NAME = "snuggletex.version";
    public static final String MAVEN_SITE_URL_PROPERTY_NAME = "maven.site.url";
    public static final String STYLESHEET_MANAGER_ATTRIBUTE_NAME = "stylesheetManager";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        StylesheetManager stylesheetManager = new StylesheetManager();
        stylesheetManager.setStylesheetCache((StylesheetCache)new SimpleStylesheetCache());
        stylesheetManager.setTransformerFactoryChooser((TransformerFactoryChooser)SaxonTransformerFactoryChooser.getInstance());
        servletContext.setAttribute(STYLESHEET_MANAGER_ATTRIBUTE_NAME, (Object)stylesheetManager);
        logger.info("Context initialised");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.info("Context destroyed");
    }
}

