/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.DOMPostProcessor;
import uk.ac.ed.ph.snuggletex.DownConvertingPostProcessor;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.SerializationOptions;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;
import uk.ac.ed.ph.snuggletex.webapp.MathMLToImageLinkPostProcessor;

abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = -2577813908466694931L;

    BaseServlet() {
    }

    public String ensureGetContextInitParam(String propertyName) throws ServletException {
        String result = this.getServletContext().getInitParameter(propertyName);
        if (result == null) {
            throw new ServletException("Context init-param " + propertyName + " is not set");
        }
        return result;
    }

    protected InputStream ensureReadResource(String resourcePathInsideWebpp) throws ServletException {
        InputStream result = this.getServletContext().getResourceAsStream(resourcePathInsideWebpp);
        if (result == null) {
            throw new ServletException("Could not read in required web resource at " + resourcePathInsideWebpp);
        }
        return result;
    }

    protected StylesheetManager getStylesheetManager() {
        return (StylesheetManager)this.getServletContext().getAttribute("stylesheetManager");
    }

    protected StylesheetCache getStylesheetCache() {
        return this.getStylesheetManager().getStylesheetCache();
    }

    protected SnuggleEngine createSnuggleEngine() {
        return new SnuggleEngine(this.getStylesheetManager());
    }

    protected Transformer getStylesheet(HttpServletRequest request, String classPathUri) throws ServletException {
        Transformer result;
        try {
            result = this.getStylesheetManager().getCompiledStylesheet(classPathUri).newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException("Could not create Transformer from Templates", (Throwable)e);
        }
        result.setParameter("context-path", request.getContextPath());
        result.setParameter("snuggletex-version", this.ensureGetContextInitParam("snuggletex.version"));
        result.setParameter("maven-site-url", this.ensureGetContextInitParam("maven.site.url"));
        return result;
    }

    protected SerializationSpecifier createMathMLSourceSerializationOptions() {
        SerializationOptions result = new SerializationOptions();
        result.setIndenting(true);
        result.setUsingNamedEntities(true);
        return result;
    }

    protected WebPageOutputOptions.WebPageType chooseBestWebPageType(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        WebPageOutputOptions.WebPageType result = WebPageOutputOptions.WebPageType.PROCESSED_HTML;
        if (userAgent != null) {
            if (userAgent.contains("MathPlayer ")) {
                result = WebPageOutputOptions.WebPageType.MATHPLAYER_HTML;
            } else if (userAgent.contains("Gecko/")) {
                result = WebPageOutputOptions.WebPageType.MOZILLA;
            }
        }
        return result;
    }

    protected WebPageOutputOptions chooseBestBaseWebPageOutputOptions(HttpServletRequest request) {
        WebPageOutputOptions.WebPageType webPageType = this.chooseBestWebPageType(request);
        WebPageOutputOptions result = WebPageOutputOptionsTemplates.createWebPageOptions((WebPageOutputOptions.WebPageType)webPageType);
        result.setMathVariantMapping(true);
        result.setAddingMathSourceAnnotations(true);
        result.setIndenting(true);
        result.setIncludingStyleElement(false);
        if (webPageType == WebPageOutputOptions.WebPageType.PROCESSED_HTML) {
            result.setDoctypePublic("-//W3C//DTD XHTML 1.0 Strict//EN");
            result.setDoctypeSystem("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            result.setDOMPostProcessors(new DOMPostProcessor[]{new DownConvertingPostProcessor(), new MathMLToImageLinkPostProcessor(request.getContextPath())});
        } else if (webPageType == WebPageOutputOptions.WebPageType.MATHPLAYER_HTML) {
            result.setDoctypePublic("-//W3C//DTD XHTML 1.0 Strict//EN");
            result.setDoctypeSystem("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        } else {
            result.setDoctypePublic("-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN");
            result.setDoctypeSystem("http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd");
        }
        return result;
    }

    protected boolean isMathMLCapable(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && (userAgent.contains("MathPlayer ") || userAgent.contains("Gecko/"));
    }

    protected boolean isInternetExplorer(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && userAgent.contains("MSIE");
    }

    protected Element extractMathMLElement(NodeList resultNodeList, boolean allowUpConversionOptionsElements) {
        Element result = null;
        int size = resultNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resultNodeList.item(i);
            if (MathMLUtilities.isMathMLElement((Node)node)) {
                if (result != null) {
                    return null;
                }
                result = (Element)node;
                continue;
            }
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0 || allowUpConversionOptionsElements && node.getNodeType() == 1 && "http://www.ph.ed.ac.uk/snuggletex".equals(node.getNamespaceURI()) && "upconversion-options".equals(node.getLocalName())) continue;
            return null;
        }
        return result;
    }
}

