/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.webapp;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SerializationSpecifier;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.upconversion.MathMLUpConverter;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.webapp.BaseServlet;

public final class ASCIIMathMLUpConversionDemoServlet
extends BaseServlet {
    private static final long serialVersionUID = 2261754980279697343L;
    private static Logger logger = LoggerFactory.getLogger(ASCIIMathMLUpConversionDemoServlet.class);
    private static final String DISPLAY_XSLT_LOCATION = "classpath:/asciimathml-upconversion-demo.xsl";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.generatePage(request, response, true, null, null, null, null, null, null);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String asciiMathInput = request.getParameter("asciiMathInput");
        String asciiMathOutput = request.getParameter("asciiMathML");
        if (asciiMathInput == null || asciiMathOutput == null) {
            logger.warn("Could not extract data from ASCIIMath: asciiMathInput={}, asciiMathOutput={}", (Object)asciiMathInput, (Object)asciiMathOutput);
            response.sendError(400, "Could not extract data passed by ASCIIMathML");
            return;
        }
        asciiMathOutput = asciiMathOutput.trim();
        MathMLUpConverter upConverter = new MathMLUpConverter(this.getStylesheetManager());
        SerializationSpecifier sourceSerializationOptions = this.createMathMLSourceSerializationOptions();
        Document upConvertedMathDocument = upConverter.upConvertASCIIMathML(asciiMathOutput, null);
        Element mathElement = upConvertedMathDocument.getDocumentElement();
        String parallelMathML = MathMLUtilities.serializeElement((Element)mathElement, (SerializationSpecifier)sourceSerializationOptions);
        String pMathMLUpConverted = MathMLUtilities.serializeDocument((Document)MathMLUtilities.isolateFirstSemanticsBranch((Element)mathElement), (SerializationSpecifier)sourceSerializationOptions);
        Document cMathMLDocument = MathMLUtilities.isolateAnnotationXML((Element)mathElement, (String)"MathML-Content");
        String cMathML = cMathMLDocument != null ? MathMLUtilities.serializeDocument((Document)cMathMLDocument, (SerializationSpecifier)sourceSerializationOptions) : null;
        String maximaInput = MathMLUtilities.extractAnnotationString((Element)mathElement, (String)"Maxima");
        logger.info("ASCIIMathML Input: {}", (Object)asciiMathInput);
        logger.info("Raw ASCIIMathML Output: {}", (Object)asciiMathOutput);
        logger.info("Final parallel MathML: {}", (Object)parallelMathML);
        this.generatePage(request, response, false, asciiMathInput, mathElement, parallelMathML, pMathMLUpConverted, cMathML, maximaInput);
    }

    private void generatePage(HttpServletRequest request, HttpServletResponse response, boolean isNewForm, String asciiMathInput, Element parallelMathMLElement, String parallelMathML, String pMathMLUpConverted, String cMathML, String maximaInput) throws IOException, ServletException {
        WebPageOutputOptions options = WebPageOutputOptionsTemplates.createWebPageOptions((WebPageOutputOptions.WebPageType)WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML);
        options.setIndenting(true);
        options.setIncludingStyleElement(false);
        SnuggleEngine engine = this.createSnuggleEngine();
        SnuggleSession session = engine.createSession();
        session.parseInput(new SnuggleInput("", "Dummy Input"));
        Transformer viewStylesheet = this.getStylesheet(request, DISPLAY_XSLT_LOCATION);
        viewStylesheet.setParameter("is-mathml-capable", this.isMathMLCapable(request));
        viewStylesheet.setParameter("is-internet-explorer", this.isInternetExplorer(request));
        viewStylesheet.setParameter("is-new-form", isNewForm);
        if (!isNewForm) {
            viewStylesheet.setParameter("ascii-math-input", asciiMathInput);
            viewStylesheet.setParameter("parallel-mathml-element", parallelMathMLElement);
            viewStylesheet.setParameter("parallel-mathml", parallelMathML);
            viewStylesheet.setParameter("pmathml-upconverted", pMathMLUpConverted);
            viewStylesheet.setParameter("cmathml", cMathML);
            viewStylesheet.setParameter("maxima-input", maximaInput);
        }
        options.setStylesheets(new Transformer[]{viewStylesheet});
        try {
            session.writeWebPage(options, (Object)response, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ServletException("Unexpected Exception", (Throwable)e);
        }
    }
}

