/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontApplier;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DPaintApplier;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontApplier;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DLosslessImageEncoder;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DPaintApplier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2D
extends Graphics2D {
    private final PDFormXObject xFormObject;
    private final Graphics2D calcGfx;
    private final PDPageContentStream contentStream;
    private BufferedImage calcImage;
    private PDDocument document;
    private final int pixelWidth;
    private final int pixelHeight;
    private final AffineTransform baseTransform;
    private AffineTransform transform = new AffineTransform();
    private IPdfBoxGraphics2DImageEncoder imageEncoder = new PdfBoxGraphics2DLosslessImageEncoder();
    private IPdfBoxGraphics2DColorMapper colorMapper = new PdfBoxGraphics2DColorMapper();
    private IPdfBoxGraphics2DFontApplier fontApplier = new PdfBoxGraphics2DFontApplier();
    private IPdfBoxGraphics2DPaintApplier paintApplier = new PdfBoxGraphics2DPaintApplier();
    private Paint paint;
    private Stroke stroke;
    private Color xorColor;
    private Font font;
    private Composite composite;
    private Shape clipShape;
    private Color backgroundColor;
    private boolean isClone = false;
    private boolean vectoringText = true;
    private Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();

    public void setFontApplier(IPdfBoxGraphics2DFontApplier fontApplier) {
        this.fontApplier = fontApplier;
    }

    public void setColorMapper(IPdfBoxGraphics2DColorMapper colorMapper) {
        this.colorMapper = colorMapper;
    }

    public void setImageEncoder(IPdfBoxGraphics2DImageEncoder imageEncoder) {
        this.imageEncoder = imageEncoder;
    }

    public void setVectoringText(boolean vectoringText) {
        this.vectoringText = vectoringText;
    }

    public void setPaintApplier(IPdfBoxGraphics2DPaintApplier paintApplier) {
        this.paintApplier = paintApplier;
    }

    public PdfBoxGraphics2D(PDDocument document, int pixelWidth, int pixelHeight) throws IOException {
        this.document = document;
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        PDAppearanceStream appearance = new PDAppearanceStream(document);
        this.xFormObject = appearance;
        this.xFormObject.setResources(new PDResources());
        this.xFormObject.setBBox(new PDRectangle((float)pixelWidth, (float)pixelHeight));
        this.contentStream = new PDPageContentStream(document, appearance, this.xFormObject.getStream().createOutputStream());
        this.contentStream.saveGraphicsState();
        this.baseTransform = new AffineTransform();
        this.baseTransform.translate(0.0, pixelHeight);
        this.baseTransform.scale(1.0, -1.0);
        this.calcImage = new BufferedImage(100, 100, 6);
        this.calcGfx = this.calcImage.createGraphics();
        this.font = this.calcGfx.getFont();
    }

    private PdfBoxGraphics2D(PdfBoxGraphics2D gfx) throws IOException {
        this.document = gfx.document;
        this.pixelWidth = gfx.pixelWidth;
        this.pixelHeight = gfx.pixelHeight;
        this.xFormObject = gfx.xFormObject;
        this.contentStream = gfx.contentStream;
        this.baseTransform = gfx.baseTransform;
        this.transform = (AffineTransform)gfx.transform.clone();
        this.calcGfx = gfx.calcGfx;
        this.calcImage = gfx.calcImage;
        this.font = gfx.font;
        this.stroke = gfx.stroke;
        this.paint = gfx.paint;
        this.clipShape = gfx.clipShape;
        this.backgroundColor = gfx.backgroundColor;
        this.colorMapper = gfx.colorMapper;
        this.fontApplier = gfx.fontApplier;
        this.imageEncoder = gfx.imageEncoder;
        this.xorColor = gfx.xorColor;
        this.isClone = true;
        this.contentStream.saveGraphicsState();
    }

    public PDFormXObject getXFormObject() {
        if (this.document != null) {
            throw new IllegalStateException("You can only get the xFormObject after you disposed the Graphics2D!");
        }
        if (this.isClone) {
            throw new IllegalStateException("You can not get the xform stream from the clone");
        }
        return this.xFormObject;
    }

    @Override
    public void dispose() {
        if (this.isClone) {
            try {
                this.contentStream.restoreGraphicsState();
            }
            catch (IOException e) {
                this.throwIOException(e);
            }
            return;
        }
        try {
            this.contentStream.restoreGraphicsState();
            this.contentStream.close();
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
        this.document = null;
        this.calcGfx.dispose();
        this.calcImage.flush();
        this.calcImage = null;
    }

    @Override
    public void draw(Shape s) {
        try {
            this.contentStream.saveGraphicsState();
            this.applyPaint();
            if (this.stroke instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)this.stroke;
                this.contentStream.setLineCapStyle(basicStroke.getEndCap());
                this.contentStream.setLineJoinStyle(basicStroke.getLineJoin());
                this.contentStream.setMiterLimit(basicStroke.getMiterLimit());
                AffineTransform tf = new AffineTransform();
                tf.concatenate(this.baseTransform);
                tf.concatenate(this.transform);
                double scaleX = tf.getScaleX();
                this.contentStream.setLineWidth((float)Math.abs((double)basicStroke.getLineWidth() * scaleX));
                float[] dashArray = basicStroke.getDashArray();
                if (dashArray != null) {
                    for (int i = 0; i < dashArray.length; ++i) {
                        dashArray[i] = (float)Math.abs((double)dashArray[i] * scaleX);
                    }
                    this.contentStream.setLineDashPattern(dashArray, (float)Math.abs((double)basicStroke.getDashPhase() * scaleX));
                }
            }
            this.walkShape(s);
            this.contentStream.stroke();
            this.contentStream.restoreGraphicsState();
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform tf = new AffineTransform();
        tf.concatenate(this.baseTransform);
        tf.concatenate(this.transform);
        tf.concatenate((AffineTransform)xform.clone());
        PDImageXObject pdImage = this.imageEncoder.encodeImage(this.document, this.contentStream, img);
        try {
            this.contentStream.saveGraphicsState();
            int imgHeight = img.getHeight(obs);
            tf.translate(0.0, imgHeight);
            tf.scale(1.0, -1.0);
            this.contentStream.transform(new Matrix(tf));
            Object keyInterpolation = this.renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(keyInterpolation)) {
                pdImage.setInterpolate(false);
            }
            this.contentStream.drawImage(pdImage, 0.0f, 0.0f, (float)img.getWidth(obs), (float)imgHeight);
            this.contentStream.restoreGraphicsState();
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
        return true;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        WritableRaster data = img.copyData(null);
        this.drawImage(new BufferedImage(img.getColorModel(), data, false, null), xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        AttributedString attributedString = new AttributedString(str);
        attributedString.addAttribute(TextAttribute.FONT, this.font);
        this.drawString(attributedString.getIterator(), x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        AffineTransform tf = new AffineTransform();
        tf.translate(x, y);
        tf.scale((float)width / (float)img.getWidth(null), (float)height / (float)img.getHeight(null));
        return this.drawImage(img, tf, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        try {
            if (bgcolor != null) {
                this.contentStream.setNonStrokingColor(this.colorMapper.mapColor(this.contentStream, bgcolor));
                this.walkShape(new Rectangle(x, y, width, height));
                this.contentStream.fill();
            }
            return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
        }
        catch (IOException e) {
            this.throwIOException(e);
            return false;
        }
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy2, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        try {
            this.contentStream.saveGraphicsState();
            int width = dx2 - dx1;
            int height = dy2 - dy1;
            this.walkShape(new Rectangle2D.Double(dx1, dy1, width, height));
            this.contentStream.clip();
            if (bgcolor != null) {
                this.contentStream.setNonStrokingColor(this.colorMapper.mapColor(this.contentStream, bgcolor));
                this.walkShape(new Rectangle(dx1, dy1, width, height));
                this.contentStream.fill();
            }
            AffineTransform tf = new AffineTransform();
            tf.translate(dx1, dy1);
            float imgWidth = img.getWidth(observer);
            float imgHeight = img.getHeight(observer);
            tf.scale((float)width / imgWidth, (float)height / imgHeight);
            tf.translate(-sx1, -sy1);
            tf.scale((float)(sx2 - sx1) / imgWidth, (float)(sy2 - sy1) / imgHeight);
            this.drawImage(img, tf, observer);
            this.contentStream.restoreGraphicsState();
            return true;
        }
        catch (IOException e) {
            this.throwIOException(e);
            return false;
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        try {
            if (this.vectoringText) {
                this.drawStringUsingShapes(iterator, x, y);
            } else {
                this.drawStringUsingText(iterator, x, y);
            }
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
    }

    private void drawStringUsingShapes(AttributedCharacterIterator iterator, float x, float y) throws IOException {
        Stroke originalStroke = this.stroke;
        Paint originalPaint = this.paint;
        TextLayout textLayout = new TextLayout(iterator, this.getFontRenderContext());
        textLayout.draw(this, x, y);
        this.paint = originalPaint;
        this.stroke = originalStroke;
    }

    private boolean iterateRun(AttributedCharacterIterator iterator, StringBuilder sb) {
        sb.setLength(0);
        int charCount = iterator.getRunLimit() - iterator.getRunStart();
        while (charCount-- >= 0) {
            char c = iterator.current();
            iterator.next();
            if (c == '\uffff') {
                return false;
            }
            sb.append(c);
        }
        return true;
    }

    private void drawStringUsingText(AttributedCharacterIterator iterator, float x, float y) throws IOException {
        this.contentStream.saveGraphicsState();
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        tf.translate(x, y);
        this.contentStream.transform(new Matrix(tf));
        Matrix textMatrix = new Matrix();
        textMatrix.scale(1.0f, -1.0f);
        this.contentStream.beginText();
        this.fontApplier.applyFont(this.document, this.contentStream, this.font);
        this.applyPaint();
        this.contentStream.setTextMatrix(textMatrix);
        this.calcGfx.setFont(this.font);
        boolean run = true;
        while (run) {
            StringBuilder sb = new StringBuilder();
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            Number fontSize = (Number)iterator.getAttribute(TextAttribute.SIZE);
            if (attributeFont != null) {
                if (fontSize != null) {
                    attributeFont = attributeFont.deriveFont(fontSize.floatValue());
                }
                this.fontApplier.applyFont(this.document, this.contentStream, attributeFont);
            }
            run = this.iterateRun(iterator, sb);
            this.contentStream.showText(sb.toString());
        }
        this.contentStream.endText();
        this.contentStream.restoreGraphicsState();
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        AffineTransform transformOrig = (AffineTransform)this.transform.clone();
        this.transform.translate(x, y);
        this.fill(g.getOutline());
        this.transform = transformOrig;
    }

    @Override
    public void fill(Shape s) {
        try {
            this.contentStream.saveGraphicsState();
            PDShading shading = this.applyPaint();
            if (shading != null) {
                this.walkShape(s);
                this.contentStream.clip();
                this.contentStream.shadingFill(shading);
            } else {
                this.walkShape(s);
                this.contentStream.fill();
            }
            this.contentStream.restoreGraphicsState();
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
    }

    private PDShading applyPaint() throws IOException {
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        return this.paintApplier.applyPaint(this.paint, this.contentStream, tf, new IPdfBoxGraphics2DPaintApplier.IPaintEnv(){

            @Override
            public IPdfBoxGraphics2DColorMapper getColorMapper() {
                return PdfBoxGraphics2D.this.colorMapper;
            }

            @Override
            public IPdfBoxGraphics2DImageEncoder getImageEncoder() {
                return PdfBoxGraphics2D.this.imageEncoder;
            }

            @Override
            public PDDocument getDocument() {
                return PdfBoxGraphics2D.this.document;
            }

            @Override
            public PDResources getResources() {
                return PdfBoxGraphics2D.this.xFormObject.getResources();
            }
        });
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        hints.clear();
        this.addRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return new RenderingHints(this.renderingHints);
    }

    @Override
    public Graphics create() {
        try {
            return new PdfBoxGraphics2D(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void translate(int x, int y) {
        this.transform.translate(x, y);
    }

    @Override
    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return null;
    }

    @Override
    public void setColor(Color color) {
        this.paint = color;
    }

    @Override
    public void setPaintMode() {
        this.xorColor = null;
    }

    @Override
    public void setXORMode(Color c1) {
        this.xorColor = c1;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.calcGfx.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clipShape != null) {
            return this.clipShape.getBounds();
        }
        return null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.clip(rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        return this.clipShape;
    }

    @Override
    public void setClip(Shape clip) {
        this.clipShape = clip;
        try {
            this.contentStream.restoreGraphicsState();
            this.contentStream.saveGraphicsState();
            if (clip != null) {
                this.walkShape(clip);
                this.contentStream.clip();
            }
        }
        catch (IOException e) {
            this.throwIOException(e);
        }
    }

    private void walkShape(Shape clip) throws IOException {
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        PathIterator pi = clip.getPathIterator(tf);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    this.contentStream.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    this.contentStream.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.contentStream.curveTo1(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.contentStream.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.contentStream.closePath();
                }
            }
            pi.next();
        }
    }

    private void throwIOException(IOException e) {
        throw new RuntimeException(e);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new IllegalStateException("copyArea() not possible!");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint p = this.paint;
        this.paint = this.backgroundColor;
        this.fillRect(x, y, width, height);
        this.paint = p;
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            path.lineTo(xPoints[i], yPoints[i]);
        }
        this.draw(path);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.transform = new AffineTransform();
        this.transform.concatenate(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape shape) {
        if (this.clipShape == null) {
            this.setClip(shape);
        } else {
            Area area = new Area(this.clipShape);
            area.intersect(new Area(shape));
            this.setClip(area);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.calcGfx.addRenderingHints(this.renderingHints);
        return this.calcGfx.getFontRenderContext();
    }
}

