/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DPaintApplier;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class PdfBoxGraphics2DPaintApplier
implements IPdfBoxGraphics2DPaintApplier {
    protected PDDocument document;
    protected PDPageContentStream contentStream;
    protected IPdfBoxGraphics2DColorMapper colorMapper;
    protected IPdfBoxGraphics2DImageEncoder imageEncoder;
    protected PDResources resources;

    @Override
    public PDShading applyPaint(Paint paint, PDPageContentStream contentStream, AffineTransform tf, IPdfBoxGraphics2DPaintApplier.IPaintEnv env) throws IOException {
        this.document = env.getDocument();
        this.resources = env.getResources();
        this.contentStream = contentStream;
        this.colorMapper = env.getColorMapper();
        this.imageEncoder = env.getImageEncoder();
        return this.applyPaint(paint, tf);
    }

    protected void applyAsStrokingColor(Color color) throws IOException {
        this.contentStream.setStrokingColor(this.colorMapper.mapColor(this.contentStream, color));
        this.contentStream.setNonStrokingColor(this.colorMapper.mapColor(this.contentStream, color));
        int alpha = color.getAlpha();
        if (alpha < 255) {
            PDExtendedGraphicsState pdExtendedGraphicsState = new PDExtendedGraphicsState();
            pdExtendedGraphicsState.setStrokingAlphaConstant(Float.valueOf((float)alpha / 255.0f));
            pdExtendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)alpha / 255.0f));
            this.contentStream.setGraphicsStateParameters(pdExtendedGraphicsState);
        }
    }

    private PDShading applyPaint(Paint paint, AffineTransform tf) throws IOException {
        if (paint instanceof Color) {
            this.applyAsStrokingColor((Color)paint);
        } else {
            if (paint.getClass().getSimpleName().equals("LinearGradientPaint")) {
                return this.buildLinearGradientShading(paint, tf);
            }
            if (paint.getClass().getSimpleName().equals("RadialGradientPaint")) {
                return this.buildRadialGradientShading(paint, tf);
            }
            if (paint instanceof GradientPaint) {
                return this.buildGradientShading(tf, (GradientPaint)paint);
            }
            if (paint instanceof TexturePaint) {
                this.applyTexturePaint((TexturePaint)paint);
            } else {
                System.err.println("Don't know paint " + paint.getClass().getName());
            }
        }
        return null;
    }

    private PDShading buildLinearGradientShading(Paint paint, AffineTransform tf) throws IOException {
        Color[] colors = (Color[])this.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = this.colorMapper.mapColor(this.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = (float[])this.getPropertyValue(paint, "getFractions");
        Point2D startPoint = (Point2D)this.getPropertyValue(paint, "getStartPoint");
        Point2D endPoint = (Point2D)this.getPropertyValue(paint, "getEndPoint");
        AffineTransform gradientTransform = (AffineTransform)this.getPropertyValue(paint, "getTransform");
        tf.concatenate(gradientTransform);
        tf.transform(startPoint, startPoint);
        tf.transform(endPoint, endPoint);
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)startPoint.getX()));
        coords.add((COSBase)new COSFloat((float)startPoint.getY()));
        coords.add((COSBase)new COSFloat((float)endPoint.getX()));
        coords.add((COSBase)new COSFloat((float)endPoint.getY()));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private PDShading buildRadialGradientShading(Paint paint, AffineTransform tf) throws IOException {
        Color[] colors = (Color[])this.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = this.colorMapper.mapColor(this.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(3);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = (float[])this.getPropertyValue(paint, "getFractions");
        Point2D centerPoint = (Point2D)this.getPropertyValue(paint, "getCenterPoint");
        Point2D focusPoint = (Point2D)this.getPropertyValue(paint, "getFocusPoint");
        AffineTransform gradientTransform = (AffineTransform)this.getPropertyValue(paint, "getTransform");
        tf.concatenate(gradientTransform);
        tf.transform(centerPoint, centerPoint);
        tf.transform(focusPoint, focusPoint);
        float radius = ((Float)this.getPropertyValue(paint, "getRadius")).floatValue();
        radius = (float)Math.abs((double)radius * tf.getScaleX());
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)centerPoint.getX()));
        coords.add((COSBase)new COSFloat((float)centerPoint.getY()));
        coords.add((COSBase)new COSFloat(0.0f));
        coords.add((COSBase)new COSFloat((float)focusPoint.getX()));
        coords.add((COSBase)new COSFloat((float)focusPoint.getY()));
        coords.add((COSBase)new COSFloat(radius));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private PDShading buildGradientShading(AffineTransform tf, GradientPaint gradientPaint) throws IOException {
        Color[] colors = new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()};
        Color firstColor = colors[0];
        PDColor firstColorMapped = this.colorMapper.mapColor(this.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = new float[]{0.0f, 1.0f};
        Point2D startPoint = gradientPaint.getPoint1();
        Point2D endPoint = gradientPaint.getPoint2();
        tf.transform(startPoint, startPoint);
        tf.transform(endPoint, endPoint);
        COSArray coords = new COSArray();
        coords.add((COSBase)new COSFloat((float)startPoint.getX()));
        coords.add((COSBase)new COSFloat((float)startPoint.getY()));
        coords.add((COSBase)new COSFloat((float)endPoint.getX()));
        coords.add((COSBase)new COSFloat((float)endPoint.getY()));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions);
        COSArray extend = new COSArray();
        extend.add((COSBase)COSBoolean.TRUE);
        extend.add((COSBase)COSBoolean.TRUE);
        shading.setFunction((PDFunction)type3);
        shading.setExtend(extend);
        return shading;
    }

    private void applyTexturePaint(TexturePaint texturePaint) throws IOException {
        Rectangle2D anchorRect = texturePaint.getAnchorRect();
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        pattern.setBBox(new PDRectangle((float)anchorRect.getX(), (float)anchorRect.getY(), (float)anchorRect.getWidth(), (float)anchorRect.getHeight()));
        pattern.setXStep((float)anchorRect.getWidth());
        pattern.setYStep((float)anchorRect.getHeight());
        AffineTransform patternTransform = new AffineTransform();
        patternTransform.translate(0.0, anchorRect.getHeight());
        patternTransform.scale(1.0, -1.0);
        pattern.setMatrix(patternTransform);
        PDAppearanceStream appearance = new PDAppearanceStream(this.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        PDPageContentStream imageContentStream = new PDPageContentStream(this.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        BufferedImage texturePaintImage = texturePaint.getImage();
        PDImageXObject imageXObject = this.imageEncoder.encodeImage(this.document, imageContentStream, texturePaintImage);
        float ratioW = (float)(anchorRect.getWidth() / (double)texturePaintImage.getWidth());
        float ratioH = (float)(anchorRect.getHeight() / (double)texturePaintImage.getHeight());
        float paintHeight = (float)texturePaintImage.getHeight() * ratioH;
        imageContentStream.drawImage(imageXObject, (float)anchorRect.getX(), (float)((double)paintHeight + anchorRect.getY()), (float)texturePaintImage.getWidth() * ratioW, -paintHeight);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null, imageXObject.getColorSpace());
        COSName tilingPatternName = this.resources.add((PDAbstractPattern)pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        this.contentStream.setNonStrokingColor(patternColor);
        this.contentStream.setStrokingColor(patternColor);
    }

    protected PDFunctionType3 buildType3Function(Color[] colors, float[] fractions) {
        COSDictionary function = new COSDictionary();
        function.setInt(COSName.FUNCTION_TYPE, 3);
        COSArray domain = new COSArray();
        domain.add((COSBase)new COSFloat(0.0f));
        domain.add((COSBase)new COSFloat(1.0f));
        COSArray encode = new COSArray();
        COSArray range = new COSArray();
        range.add((COSBase)new COSFloat(0.0f));
        range.add((COSBase)new COSFloat(1.0f));
        COSArray bounds = new COSArray();
        for (int i = 2; i < colors.length; ++i) {
            bounds.add((COSBase)new COSFloat(1.0f / (float)colors.length * (float)(i - 1)));
        }
        COSArray functions = this.buildType2Functions(colors, domain, encode);
        function.setItem(COSName.FUNCTIONS, (COSBase)functions);
        function.setItem(COSName.BOUNDS, (COSBase)bounds);
        function.setItem(COSName.ENCODE, (COSBase)encode);
        PDFunctionType3 type3 = new PDFunctionType3((COSBase)function);
        type3.setDomainValues(domain);
        return type3;
    }

    protected COSArray buildType2Functions(Color[] colors, COSArray domain, COSArray encode) {
        Color prevColor = colors[0];
        COSArray functions = new COSArray();
        for (int i = 1; i < colors.length; ++i) {
            Color color = colors[i];
            PDColor prevPdColor = this.colorMapper.mapColor(this.contentStream, prevColor);
            PDColor pdColor = this.colorMapper.mapColor(this.contentStream, color);
            COSArray c0 = new COSArray();
            COSArray c1 = new COSArray();
            for (float component : prevPdColor.getComponents()) {
                c0.add((COSBase)new COSFloat(component));
            }
            for (float component : pdColor.getComponents()) {
                c1.add((COSBase)new COSFloat(component));
            }
            COSDictionary type2Function = new COSDictionary();
            type2Function.setInt(COSName.FUNCTION_TYPE, 2);
            type2Function.setItem(COSName.C0, (COSBase)c0);
            type2Function.setItem(COSName.C1, (COSBase)c1);
            type2Function.setInt(COSName.N, 1);
            type2Function.setItem(COSName.DOMAIN, (COSBase)domain);
            functions.add((COSBase)type2Function);
            encode.add((COSBase)new COSFloat(0.0f));
            encode.add((COSBase)new COSFloat(1.0f));
            prevColor = color;
        }
        return functions;
    }

    protected <T> T getPropertyValue(Object obj, String propertyGetter) {
        try {
            for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
                try {
                    Method m = c.getMethod(propertyGetter, null);
                    return (T)m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            throw new NullPointerException("Method " + propertyGetter + " not found!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

