/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.validation.tools;

import com.google.common.collect.Lists;
import de.richtercloud.validation.tools.FieldNameLambda;
import de.richtercloud.validation.tools.FieldRetriever;
import de.richtercloud.validation.tools.OutputMode;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;

public final class ValidationUtils {
    public static <T> String buildConstraintVioloationMessage(Set<ConstraintViolation<T>> violations, Object instance, FieldRetriever fieldRetriever, Map<Path, String> pathDescriptionMap, FieldNameLambda fieldNameLambda, boolean skipPathes, OutputMode outputMode) {
        if (violations == null) {
            throw new IllegalArgumentException("violations mustn't be null");
        }
        if (violations.isEmpty()) {
            throw new IllegalArgumentException("violations mustn't be empty");
        }
        if (fieldRetriever == null) {
            throw new IllegalArgumentException("fieldRetriever mustn't be null");
        }
        if (pathDescriptionMap == null) {
            throw new IllegalArgumentException("pathDescriptionMap mustn't be null");
        }
        if (fieldNameLambda == null) {
            throw new IllegalArgumentException("fieldNameLambda mustn't be null");
        }
        if (outputMode == null) {
            throw new IllegalArgumentException("outputMode mustn't be null");
        }
        StringBuilder messageBuilder = new StringBuilder(1000);
        if (outputMode == OutputMode.HTML_HTML) {
            messageBuilder.append("<html>");
        } else if (outputMode == OutputMode.HTML_DIV) {
            messageBuilder.append("<div>");
        }
        messageBuilder.append("The following constraints are violated:");
        if (outputMode == OutputMode.HTML_HTML || outputMode == OutputMode.HTML_DIV) {
            messageBuilder.append("<br/>");
        } else {
            messageBuilder.append('\n');
        }
        for (ConstraintViolation<T> violation : violations) {
            if (!skipPathes) {
                String pathString = pathDescriptionMap.get(violation.getPropertyPath());
                if (pathString == null) {
                    StringBuilder pathStringBuilder = new StringBuilder(1024);
                    Class relativeFieldRoot = instance.getClass();
                    ArrayList propertyPathNodes = Lists.newArrayList((Iterable)violation.getPropertyPath());
                    int index = 0;
                    for (Path.Node propertyPathNode : violation.getPropertyPath()) {
                        String specialFieldName;
                        if (propertyPathNode.getKind() != ElementKind.PROPERTY && propertyPathNode.getKind() != ElementKind.BEAN) {
                            throw new IllegalArgumentException(String.format("only kinds %s and %s are supported", ElementKind.PROPERTY, ElementKind.BEAN));
                        }
                        Field violationField = null;
                        if (propertyPathNode.getKind() != ElementKind.PROPERTY) continue;
                        String violationFieldName = propertyPathNode.getName();
                        List<Field> classFields = fieldRetriever.retrieveRelevantFields(relativeFieldRoot);
                        for (Field classField : classFields) {
                            if (!classField.getName().equals(violationFieldName)) continue;
                            violationField = classField;
                            break;
                        }
                        if (violationField == null) {
                            throw new IllegalArgumentException("validation violoation constraint on field which isn't part of the validated instance");
                        }
                        if (index + 1 < propertyPathNodes.size()) {
                            if (!((Path.Node)propertyPathNodes.get(index + 1)).isInIterable()) {
                                relativeFieldRoot = violationField.getType();
                            } else {
                                if (!(violationField.getGenericType() instanceof ParameterizedType)) {
                                    throw new IllegalArgumentException("all collections involving validation need to be parameterized");
                                }
                                ParameterizedType violationFieldParameterizedType = (ParameterizedType)violationField.getGenericType();
                                if (violationFieldParameterizedType.getActualTypeArguments().length != 1) {
                                    throw new IllegalArgumentException("only collections with one parameterized type are supported");
                                }
                                Type violoationFieldOnlyGenericType = violationFieldParameterizedType.getActualTypeArguments()[0];
                                if (!(violoationFieldOnlyGenericType instanceof Class)) {
                                    throw new IllegalArgumentException(String.format("the collection's parameterized type has to be a class (as opposed to other possibilites for generic types) (was %s)", violoationFieldOnlyGenericType));
                                }
                                relativeFieldRoot = (Class)violoationFieldOnlyGenericType;
                            }
                        }
                        String fieldName = (specialFieldName = fieldNameLambda.getFieldName(violationField)) != null ? specialFieldName : violationField.getName();
                        pathStringBuilder.append(fieldName);
                        pathStringBuilder.append(": ");
                        ++index;
                    }
                    pathString = pathStringBuilder.toString();
                }
                messageBuilder.append(pathString);
            }
            messageBuilder.append(violation.getMessage());
            if (outputMode == OutputMode.HTML_HTML || outputMode == OutputMode.HTML_DIV) {
                messageBuilder.append("<br/>");
                continue;
            }
            messageBuilder.append('\n');
        }
        messageBuilder.append("Fix the corresponding values in the components.");
        if (outputMode == OutputMode.HTML_HTML) {
            messageBuilder.append("</html>");
        } else if (outputMode == OutputMode.HTML_DIV) {
            messageBuilder.append("</div>");
        }
        return messageBuilder.toString();
    }

    public static <T> String buildConstraintVioloationMessage(Set<ConstraintViolation<T>> violations, Object instance, FieldRetriever fieldRetriever, FieldNameLambda fieldNameLambda, boolean skipPathes, OutputMode outputMode) {
        return ValidationUtils.buildConstraintVioloationMessage(violations, instance, fieldRetriever, new HashMap<Path, String>(), fieldNameLambda, skipPathes, outputMode);
    }

    public static <T> String buildConstraintVioloationMessage(Set<ConstraintViolation<T>> violations, Object instance, FieldRetriever fieldRetriever, FieldNameLambda fieldNameLambda, OutputMode outputMode) {
        return ValidationUtils.buildConstraintVioloationMessage(violations, instance, fieldRetriever, new HashMap<Path, String>(), fieldNameLambda, false, outputMode);
    }

    public static <T> String buildConstraintVioloationMessage(Set<ConstraintViolation<T>> violations, Object instance, FieldRetriever fieldRetriever, Map<Path, String> pathDescriptionMap, OutputMode outputMode) {
        return ValidationUtils.buildConstraintVioloationMessage(violations, instance, fieldRetriever, pathDescriptionMap, field -> field.getName(), false, outputMode);
    }

    public static <T> String buildConstraintVioloationMessage(Set<ConstraintViolation<T>> violations, Object instance, FieldRetriever fieldRetriever, OutputMode outputMode) {
        return ValidationUtils.buildConstraintVioloationMessage(violations, instance, fieldRetriever, new HashMap<Path, String>(), field -> field.getName(), false, outputMode);
    }

    private ValidationUtils() {
    }
}

