/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.validation.tools;

import de.richtercloud.validation.tools.FieldRetriever;
import de.richtercloud.validation.tools.annotations.Skip;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachedFieldRetriever
implements FieldRetriever {
    private final Map<Class<?>, List<Field>> relevantFieldsCache = new HashMap();
    private final Lock cacheLock = new ReentrantLock(true);

    public static List<Class<?>> generateInheritanceHierarchy(Class<?> entityClass) {
        LinkedList retValue = new LinkedList();
        for (Class<?> hierarchyPointer = entityClass; hierarchyPointer != null && !hierarchyPointer.equals(Object.class); hierarchyPointer = hierarchyPointer.getSuperclass()) {
            retValue.add(hierarchyPointer);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Field> retrieveRelevantFields(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz mustn't be null");
        }
        LinkedList<Field> retValue = new LinkedList<Field>();
        try {
            this.cacheLock.lock();
            List<Field> retValueCandidate = this.relevantFieldsCache.get(clazz);
            if (retValueCandidate != null) {
                LinkedList<Field> linkedList = new LinkedList<Field>(retValueCandidate);
                return linkedList;
            }
            List<Class<?>> hierarchyClasses = CachedFieldRetriever.generateInheritanceHierarchy(clazz);
            for (Class<?> hierarchyClass : hierarchyClasses) {
                retValue.addAll(Arrays.asList(hierarchyClass.getDeclaredFields()));
            }
            HashSet<Field> seenEntityClassFields = new HashSet<Field>();
            ListIterator entityClassFieldsIt = retValue.listIterator();
            while (entityClassFieldsIt.hasNext()) {
                Field entityClassFieldsNxt = (Field)entityClassFieldsIt.next();
                if (Modifier.isStatic(entityClassFieldsNxt.getModifiers())) {
                    entityClassFieldsIt.remove();
                    continue;
                }
                if (Modifier.isTransient(entityClassFieldsNxt.getModifiers())) {
                    entityClassFieldsIt.remove();
                    continue;
                }
                if (seenEntityClassFields.contains(entityClassFieldsNxt)) {
                    entityClassFieldsIt.remove();
                    continue;
                }
                Skip entityClassFieldNxtSkip = entityClassFieldsNxt.getAnnotation(Skip.class);
                if (entityClassFieldNxtSkip != null) {
                    entityClassFieldsIt.remove();
                    continue;
                }
                seenEntityClassFields.add(entityClassFieldsNxt);
                entityClassFieldsNxt.setAccessible(true);
            }
            this.relevantFieldsCache.put(clazz, retValue);
        }
        finally {
            this.cacheLock.unlock();
        }
        return retValue;
    }

    protected void overwriteCachedResult(Class<?> entityClass, List<Field> relevantFields) {
        try {
            this.cacheLock.lock();
            this.relevantFieldsCache.put(entityClass, relevantFields);
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

