/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.test.tools;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelITExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelITExecutor.class);

    public void executeLambdaInParallel(int parallelism, Callable<Void> parallelITLambda) throws ExecutionException, InterruptedException {
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 0; i < parallelism; ++i) {
            Future<Void> future = executorService.submit(parallelITLambda);
            futures.add(future);
        }
        executorService.shutdown();
        while (!futures.isEmpty()) {
            LOGGER.debug(String.format("waiting for %d parallel test runs to complete", futures.size()));
            Future future = (Future)futures.poll();
            future.get();
        }
    }
}

