/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.selenium.tools;

import com.natpryce.hamkrest.Core_matchersKt;
import com.natpryce.hamkrest.Matcher;
import de.richtercloud.jsf.validation.service.MemoryValidationService;
import de.richtercloud.jsf.validation.service.MessageValidatorMessageMatcher;
import de.richtercloud.jsf.validation.service.ValidationService;
import de.richtercloud.jsf.validation.service.ValidatorMessage;
import de.richtercloud.jsf.validation.service.ValidatorMessageSeverity;
import de.richtercloud.selenium.tools.MessageTextNotContainedException;
import de.richtercloud.selenium.tools.PageSourceInvalidException;
import de.richtercloud.selenium.tools.ResponseCodeUnequalsException;
import de.richtercloud.selenium.tools.WaitExceptionAction;
import de.richtercloud.selenium.tools.WaitExceptionActions;
import de.richtercloud.selenium.tools.WebDriverWaitException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.iterators.PermutationIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ru.yandex.qatools.ashot.AShot;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.shooting.ShootingStrategies;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 P2\u00020\u0001:\u0002PQB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bBA\b\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J$\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#2\u0006\u0010$\u001a\u00020\u0016H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\nH\u0002J/\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\n2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u0002012\u0006\u00102\u001a\u000203J \u00104\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0002J\u0016\u00104\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u000203J2\u00106\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00102\u001a\u0002032\b\b\u0002\u00107\u001a\u0002082\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0007J,\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>2\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:J\u0010\u0010?\u001a\u00020\n2\u0006\u00105\u001a\u00020\nH\u0002J\u0016\u0010@\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010@\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010A\u001a\u0004\u0018\u00010\n2\u0006\u0010B\u001a\u00020\u001bH\u0002J\u001a\u0010C\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010*\u001a\u00020\nH\u0007J\u001c\u0010D\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010*\u001a\u00020\nH\u0007J*\u0010E\u001a\u00020\u00142\u0006\u00105\u001a\u00020\n2\b\b\u0002\u0010F\u001a\u0002082\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0007J,\u0010G\u001a\u00020\u0014\"\u0004\b\u0000\u0010H2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010I\u001a\u0012\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002HH0JJ4\u0010G\u001a\u00020\u0014\"\u0004\b\u0000\u0010H2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010I\u001a\u0012\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002HH0J2\u0006\u0010K\u001a\u00020\nJM\u0010G\u001a\u00020\u0014\"\u0004\b\u0000\u0010H2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010I\u001a\u0012\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002HH0J2\u0006\u0010L\u001a\u00020\n2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.\u00a2\u0006\u0002\u0010MJ<\u0010G\u001a\u00020\u0014\"\u0004\b\u0000\u0010H2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010I\u001a\u0012\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002HH0J2\u0006\u0010K\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u0003JU\u0010G\u001a\u00020\u0014\"\u0004\b\u0000\u0010H2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\u0010I\u001a\u0012\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u0002HH0J2\u0006\u0010L\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u00032\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020.0-\"\u00020.\u00a2\u0006\u0002\u0010OR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lde/richtercloud/selenium/tools/SeleniumHelper;", "", "webDriverWaitTimeout", "", "(I)V", "screenshotDir", "Ljava/io/File;", "(Ljava/io/File;)V", "(ILjava/io/File;)V", "screenshotStartMarker", "", "screeenshotEndMarker", "pageSourceStartMarker", "pageSourceEndMarker", "validationService", "Lde/richtercloud/jsf/validation/service/ValidationService;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/io/File;Lde/richtercloud/jsf/validation/service/ValidationService;)V", "screenshotCounter", "screenshotEndMarker", "assertMessagesContains", "", "browser", "Lorg/openqa/selenium/WebDriver;", "messages", "Lorg/openqa/selenium/WebElement;", "messageText", "waitForMessageText", "", "assertMessagesContainsAny", "texts", "", "compressGzipAndEncodeBytes", "screenshotBytes", "", "createFluentWait", "Lorg/openqa/selenium/support/ui/FluentWait;", "webDriver", "createWebDriverWait", "Lorg/openqa/selenium/support/ui/WebDriverWait;", "timeOutInSeconds", "", "generateScreenshotFilename", "description", "handleWaitException", "waitExceptionActions", "", "Lde/richtercloud/selenium/tools/WaitExceptionAction;", "(Lorg/openqa/selenium/WebDriver;Ljava/lang/String;[Lde/richtercloud/selenium/tools/WaitExceptionAction;)V", "logDOMTree", "Lorg/openqa/selenium/JavascriptExecutor;", "logger", "Lorg/slf4j/Logger;", "logPageSource", "pageSource", "logPageSourcePretty", "validationMinimumLevel", "Lde/richtercloud/jsf/validation/service/ValidatorMessageSeverity;", "ignore", "Lcom/natpryce/hamkrest/Matcher;", "Lde/richtercloud/jsf/validation/service/ValidatorMessage;", "logPageSourceURLPretty", "url", "Ljava/net/URL;", "prettyPrintPageSource", "retrieveMessagesText", "expectedText", "waitForExpectedText", "screenshot", "screenshotFullPage", "validatePageSource", "minimumLevel", "webDriverWait", "V", "condition", "Ljava/util/function/Function;", "exceptionScreenshotDescription", "exceptionDescription", "(Lorg/openqa/selenium/WebDriver;Ljava/util/function/Function;Ljava/lang/String;[Lde/richtercloud/selenium/tools/WaitExceptionAction;)V", "overrideWebDriverWaitTimout", "(Lorg/openqa/selenium/WebDriver;Ljava/util/function/Function;Ljava/lang/String;I[Lde/richtercloud/selenium/tools/WaitExceptionAction;)V", "Companion", "TextToBePresentInElementWithText", "selenium-tools"})
public class SeleniumHelper {
    private final File screenshotDir;
    private int screenshotCounter;
    private final String screenshotStartMarker;
    private final String screenshotEndMarker;
    private final String pageSourceStartMarker;
    private final String pageSourceEndMarker;
    private final int webDriverWaitTimeout;
    private final ValidationService validationService;
    private static final Logger LOGGER;
    private static final String SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME = "screenshotOutputMode";
    private static final String SCREENSHOT_OUTPUT_MODE_FILE = "file";
    private static final String SCREENSHOT_OUTPUT_MODE_BASE64 = "base64";
    private static final String SCREENSHOT_OUTPUT_MODE_BASE64_GZIP = "base64-gzip";
    private static final String NO_DESCRIPTION = "no description";
    private static final String DOCTYPE_TEMPLATE = "<!DOCTYPE html>";
    private static final String WHITESPACE_TEMPLATE = "\\s+";
    @NotNull
    public static final String SCREENSHOT_START_MARKER_DEFAULT = "---";
    @NotNull
    public static final String SCREENSHOT_END_MARKER_DEFAULT = "---";
    @NotNull
    public static final String PAGE_SOURCE_START_MARKER_DEFAULT = "===";
    @NotNull
    public static final String PAGE_SOURCE_END_MARKER_DEFAULT = "===";
    public static final int WEB_DRIVER_WAIT_TIMEOUT_DEFAULT = 5;
    private static final String LOG_DESCRIPTION_PAGE_SOURCE = "browser page source";
    private static final String LOG_DESCRIPTION_DOM_TREE = "DOM tree";
    @NotNull
    private static final Matcher<ValidatorMessage> MISSING_DOCTYPE_MESSAGE_MATCHER;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String retrieveMessagesText(@NotNull WebDriver browser, @NotNull WebElement messages) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        return this.retrieveMessagesText(browser, messages, null, false);
    }

    private final String retrieveMessagesText(WebDriver browser, WebElement messages, String expectedText, boolean waitForExpectedText) throws WebDriverWaitException {
        LOGGER.trace("retrieveMessagesText expectedText: " + expectedText);
        LOGGER.trace("retrieveMessagesText messages.text: " + messages.getText());
        ExpectedCondition expectedCondition = ExpectedConditions.visibilityOf((WebElement)messages);
        Intrinsics.checkNotNullExpressionValue((Object)expectedCondition, (String)"ExpectedConditions.visibilityOf(messages)");
        this.webDriverWait(browser, (Function)expectedCondition);
        if (expectedText != null) {
            if (waitForExpectedText) {
                try {
                    ExpectedCondition expectedCondition2 = ExpectedConditions.textToBePresentInElement((WebElement)messages, (String)expectedText);
                    Intrinsics.checkNotNullExpressionValue((Object)expectedCondition2, (String)"ExpectedConditions.textT\u2026                        )");
                    this.webDriverWait(browser, (Function)expectedCondition2);
                }
                catch (TimeoutException ex) {
                    throw (Throwable)new MessageTextNotContainedException(expectedText, messages.getText());
                }
            }
            if (Intrinsics.areEqual((Object)expectedText, (Object)messages.getText()) ^ true) {
                throw (Throwable)new MessageTextNotContainedException(expectedText, messages.getText());
            }
        }
        String retValue = messages.getText();
        boolean bl = expectedText == null || Intrinsics.areEqual((Object)expectedText, (Object)retValue);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "expectedText '" + expectedText + "' is not equal to retValue '" + retValue + '\'';
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = retValue;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"retValue");
        return string;
    }

    @JvmOverloads
    public final void assertMessagesContains(@NotNull WebDriver browser, @NotNull WebElement messages, @NotNull String messageText, boolean waitForMessageText) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        ExpectedCondition expectedCondition = ExpectedConditions.visibilityOf((WebElement)messages);
        Intrinsics.checkNotNullExpressionValue((Object)expectedCondition, (String)"ExpectedConditions.visibilityOf(messages)");
        this.webDriverWait(browser, (Function)expectedCondition);
        String messagesText = this.retrieveMessagesText(browser, messages, messageText, waitForMessageText);
        boolean bl = Intrinsics.areEqual((Object)messageText, (Object)messagesText);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public static /* synthetic */ void assertMessagesContains$default(SeleniumHelper seleniumHelper, WebDriver webDriver, WebElement webElement, String string, boolean bl, int n, Object object) throws WebDriverWaitException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertMessagesContains");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        seleniumHelper.assertMessagesContains(webDriver, webElement, string, bl);
    }

    @JvmOverloads
    public final void assertMessagesContains(@NotNull WebDriver browser, @NotNull WebElement messages, @NotNull String messageText) throws WebDriverWaitException {
        SeleniumHelper.assertMessagesContains$default(this, browser, messages, messageText, false, 8, null);
    }

    public final void assertMessagesContainsAny(@NotNull WebDriver browser, @NotNull WebElement messages, @NotNull Set<String> texts) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Collection collection = texts;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "texts mustn't be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterator<String> textsItr = texts.iterator();
        String text = textsItr.next();
        String messagesText = null;
        try {
            this.retrieveMessagesText(browser, messages, text, true);
            return;
        }
        catch (MessageTextNotContainedException ex) {
            String string;
            messagesText = string = this.retrieveMessagesText(browser, messages, null, false);
            while (textsItr.hasNext()) {
                text = textsItr.next();
                if (!Intrinsics.areEqual((Object)text, (Object)messagesText)) continue;
                return;
            }
            LOGGER.trace("messages.innerHTML: " + messages.getAttribute("innerHTML"));
            throw (Throwable)new MessageTextNotContainedException(texts, messages.getText());
        }
    }

    private final String compressGzipAndEncodeBytes(byte[] screenshotBytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        ByteArrayInputStream screenshotBytesInputStream = new ByteArrayInputStream(screenshotBytes);
        IOUtils.copy((InputStream)screenshotBytesInputStream, (OutputStream)gZIPOutputStream);
        byte[] compressedScreenshotBytes = byteArrayOutputStream.toByteArray();
        String string = Base64.getEncoder().encodeToString(compressedScreenshotBytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.getEncoder().enco\u2026ompressedScreenshotBytes)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final void screenshot(@NotNull WebDriver browser, @NotNull String description) throws WebDriverWaitException {
        String screenshotOutputMode;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (!(browser instanceof TakesScreenshot)) {
            LOGGER.debug("browser doesn't support taking screenshots");
            return;
        }
        String string = screenshotOutputMode = System.getProperty(SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME, SCREENSHOT_OUTPUT_MODE_FILE);
        if (string == null) throw (Throwable)new IllegalArgumentException("Illegal value '" + screenshotOutputMode + "' specified for property screenshotOutputMode");
        switch (string) {
            case "file": {
                File scrFile = (File)((TakesScreenshot)browser).getScreenshotAs(OutputType.FILE);
                try {
                    FileUtils.copyFile((File)scrFile, (File)new File(this.screenshotDir, this.generateScreenshotFilename(this.screenshotCounter, description)));
                    break;
                }
                catch (IOException ex) {
                    throw (Throwable)new WebDriverWaitException(ex);
                }
            }
            case "base64": {
                String screenshotBase64 = (String)((TakesScreenshot)browser).getScreenshotAs(OutputType.BASE64);
                LOGGER.info("base64 encoding of screenshot with description '" + description + "':\n" + this.screenshotStartMarker + '\n' + screenshotBase64 + '\n' + this.screenshotEndMarker);
                break;
            }
            case "base64-gzip": {
                String string2;
                byte[] screenshotBytes = (byte[])((TakesScreenshot)browser).getScreenshotAs(OutputType.BYTES);
                String compressedScreenshotBase64 = null;
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)screenshotBytes, (String)"screenshotBytes");
                    string2 = this.compressGzipAndEncodeBytes(screenshotBytes);
                }
                catch (IOException ex) {
                    throw (Throwable)new WebDriverWaitException(ex);
                }
                compressedScreenshotBase64 = string2;
                LOGGER.info("gzip compresed base64 encoding of screenshot with description '" + description + "':\n" + this.screenshotStartMarker + '\n' + compressedScreenshotBase64 + '\n' + this.screenshotEndMarker);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Illegal value '" + screenshotOutputMode + "' specified for property screenshotOutputMode");
            }
        }
        int n = this.screenshotCounter;
        this.screenshotCounter = n + 1;
    }

    public static /* synthetic */ void screenshot$default(SeleniumHelper seleniumHelper, WebDriver webDriver, String string, int n, Object object) throws WebDriverWaitException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: screenshot");
        }
        if ((n & 2) != 0) {
            string = NO_DESCRIPTION;
        }
        seleniumHelper.screenshot(webDriver, string);
    }

    @JvmOverloads
    public final void screenshot(@NotNull WebDriver browser) throws WebDriverWaitException {
        SeleniumHelper.screenshot$default(this, browser, null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public final void screenshotFullPage(@Nullable WebDriver browser, @NotNull String description) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String screenshotOutputMode = System.getProperty(SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME, SCREENSHOT_OUTPUT_MODE_FILE);
        Screenshot fpScreenshot = null;
        String string = screenshotOutputMode;
        if (string == null) throw (Throwable)new IllegalArgumentException("Illegal value '" + screenshotOutputMode + "' specified for property screenshotOutputMode");
        switch (string) {
            case "file": {
                Screenshot screenshot2 = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                Intrinsics.checkNotNullExpressionValue((Object)screenshot2, (String)"AShot().shootingStrategy\u2026).takeScreenshot(browser)");
                fpScreenshot = screenshot2;
                File outputFile = new File(this.screenshotDir, this.generateScreenshotFilename(this.screenshotCounter, description));
                LOGGER.info("screenshot output filename: {}", (Object)outputFile.getName());
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", outputFile);
                    break;
                }
                catch (IOException ex) {
                    throw (Throwable)new WebDriverWaitException(ex);
                }
            }
            case "base64": {
                Screenshot screenshot3 = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                Intrinsics.checkNotNullExpressionValue((Object)screenshot3, (String)"AShot().shootingStrategy\u2026).takeScreenshot(browser)");
                fpScreenshot = screenshot3;
                ByteArrayOutputStream imageOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", imageOutputStream);
                }
                catch (IOException ex) {
                    throw (Throwable)new WebDriverWaitException(ex);
                }
                String screenshotBase64 = Base64.getEncoder().encodeToString(imageOutputStream.toByteArray());
                LOGGER.info("base64 encoding of screenshot with description '" + description + "':\n" + this.screenshotStartMarker + '\n' + screenshotBase64 + '\n' + this.screenshotEndMarker);
                break;
            }
            case "base64-gzip": {
                Screenshot screenshot4 = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                Intrinsics.checkNotNullExpressionValue((Object)screenshot4, (String)"AShot().shootingStrategy\u2026).takeScreenshot(browser)");
                fpScreenshot = screenshot4;
                ByteArrayOutputStream imageOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", imageOutputStream);
                    byte[] byArray = imageOutputStream.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"imageOutputStream.toByteArray()");
                    String compressedScreenshotBase64 = this.compressGzipAndEncodeBytes(byArray);
                    LOGGER.info("gzip compresed base64 encoding of screenshot with description '" + description + "':\n" + this.screenshotStartMarker + '\n' + compressedScreenshotBase64 + '\n' + this.screenshotEndMarker);
                    break;
                }
                catch (IOException ex) {
                    throw (Throwable)new WebDriverWaitException(ex);
                }
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Illegal value '" + screenshotOutputMode + "' specified for property screenshotOutputMode");
            }
        }
        int n = this.screenshotCounter;
        this.screenshotCounter = n + 1;
    }

    public static /* synthetic */ void screenshotFullPage$default(SeleniumHelper seleniumHelper, WebDriver webDriver, String string, int n, Object object) throws WebDriverWaitException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: screenshotFullPage");
        }
        if ((n & 2) != 0) {
            string = NO_DESCRIPTION;
        }
        seleniumHelper.screenshotFullPage(webDriver, string);
    }

    @JvmOverloads
    public final void screenshotFullPage(@Nullable WebDriver browser) throws WebDriverWaitException {
        SeleniumHelper.screenshotFullPage$default(this, browser, null, 2, null);
    }

    private final String generateScreenshotFilename(int screenshotCounter, String description) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%05d-%s.png";
        Object[] objectArray = new Object[]{screenshotCounter, description};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public final void validatePageSource(@NotNull String pageSource, @NotNull ValidatorMessageSeverity minimumLevel, @NotNull Matcher<? super ValidatorMessage> ignore) throws SAXException, IOException, PageSourceInvalidException {
        Intrinsics.checkNotNullParameter((Object)pageSource, (String)"pageSource");
        Intrinsics.checkNotNullParameter((Object)minimumLevel, (String)"minimumLevel");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        String string = pageSource;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        List violations = this.validationService.validateMessages((InputStream)new ByteArrayInputStream(byArray), minimumLevel, ignore);
        if (!violations.isEmpty()) {
            throw (Throwable)new PageSourceInvalidException(ValidationService.Companion.transformValidatorResponse(violations));
        }
    }

    public static /* synthetic */ void validatePageSource$default(SeleniumHelper seleniumHelper, String string, ValidatorMessageSeverity validatorMessageSeverity, Matcher matcher, int n, Object object) throws SAXException, IOException, PageSourceInvalidException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validatePageSource");
        }
        if ((n & 2) != 0) {
            validatorMessageSeverity = ValidatorMessageSeverity.WARNING;
        }
        if ((n & 4) != 0) {
            matcher = MISSING_DOCTYPE_MESSAGE_MATCHER;
        }
        seleniumHelper.validatePageSource(string, validatorMessageSeverity, matcher);
    }

    @JvmOverloads
    public final void validatePageSource(@NotNull String pageSource, @NotNull ValidatorMessageSeverity minimumLevel) throws SAXException, IOException, PageSourceInvalidException {
        SeleniumHelper.validatePageSource$default(this, pageSource, minimumLevel, null, 4, null);
    }

    @JvmOverloads
    public final void validatePageSource(@NotNull String pageSource) throws SAXException, IOException, PageSourceInvalidException {
        SeleniumHelper.validatePageSource$default(this, pageSource, null, null, 6, null);
    }

    public final void logPageSource(@NotNull WebDriver browser, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        String string = browser.getPageSource();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"browser.pageSource");
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, string, logger);
    }

    @JvmOverloads
    public final void logPageSourcePretty(@NotNull WebDriver browser, @NotNull Logger logger, @NotNull ValidatorMessageSeverity validationMinimumLevel, @NotNull Matcher<? super ValidatorMessage> ignore) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)validationMinimumLevel, (String)"validationMinimumLevel");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        String pageSource = browser.getPageSource();
        try {
            String string = pageSource;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pageSource");
            this.validatePageSource(string, validationMinimumLevel, ignore);
        }
        catch (SAXException ex) {
            throw (Throwable)new WebDriverWaitException(ex);
        }
        catch (IOException ex) {
            throw (Throwable)new WebDriverWaitException(ex);
        }
        catch (PageSourceInvalidException ex) {
            throw (Throwable)new WebDriverWaitException(ex);
        }
        String pageSourcePretty = this.prettyPrintPageSource(pageSource);
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, pageSourcePretty, logger);
    }

    public static /* synthetic */ void logPageSourcePretty$default(SeleniumHelper seleniumHelper, WebDriver webDriver, Logger logger, ValidatorMessageSeverity validatorMessageSeverity, Matcher matcher, int n, Object object) throws WebDriverWaitException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logPageSourcePretty");
        }
        if ((n & 4) != 0) {
            validatorMessageSeverity = ValidatorMessageSeverity.WARNING;
        }
        if ((n & 8) != 0) {
            matcher = Core_matchersKt.getNothing();
        }
        seleniumHelper.logPageSourcePretty(webDriver, logger, validatorMessageSeverity, (Matcher<? super ValidatorMessage>)matcher);
    }

    @JvmOverloads
    public final void logPageSourcePretty(@NotNull WebDriver browser, @NotNull Logger logger, @NotNull ValidatorMessageSeverity validationMinimumLevel) throws WebDriverWaitException {
        SeleniumHelper.logPageSourcePretty$default(this, browser, logger, validationMinimumLevel, null, 8, null);
    }

    @JvmOverloads
    public final void logPageSourcePretty(@NotNull WebDriver browser, @NotNull Logger logger) throws WebDriverWaitException {
        SeleniumHelper.logPageSourcePretty$default(this, browser, logger, null, null, 12, null);
    }

    public final void logPageSourceURLPretty(@NotNull URL url, @NotNull Logger logger, @NotNull ValidatorMessageSeverity validationMinimumLevel, @NotNull Matcher<? super ValidatorMessage> ignore) throws IOException, SAXException, PageSourceInvalidException {
        String pageSource;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)validationMinimumLevel, (String)"validationMinimumLevel");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        String string = pageSource = IOUtils.toString((URL)url, (Charset)Charset.defaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pageSource");
        this.validatePageSource(string, validationMinimumLevel, ignore);
        String pageSourcePretty = this.prettyPrintPageSource(pageSource);
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, pageSourcePretty, logger);
    }

    private final void logPageSource(String description, String pageSource, Logger logger) {
        logger.info(description + ":\n" + this.pageSourceStartMarker + '\n' + pageSource + '\n' + this.pageSourceEndMarker);
    }

    public final void logDOMTree(@NotNull JavascriptExecutor browser, @NotNull Logger logger) throws ParserConfigurationException, SAXException, IOException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Object object = browser.executeScript("return document.childNodes[1].outerHTML;", new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String htmlOuterHtml = (String)object;
        String pageSourcePretty = this.prettyPrintPageSource(htmlOuterHtml);
        this.logPageSource(LOG_DESCRIPTION_DOM_TREE, pageSourcePretty, logger);
    }

    private final String prettyPrintPageSource(String pageSource) {
        Document doc = Jsoup.parse((String)pageSource);
        doc.outputSettings().prettyPrint(true);
        String pageSourcePretty = doc.html();
        if (StringUtils.startsWithIgnoreCase((CharSequence)pageSource, (CharSequence)DOCTYPE_TEMPLATE)) {
            boolean bl = StringUtils.startsWithIgnoreCase((CharSequence)pageSource, (CharSequence)DOCTYPE_TEMPLATE);
            int n = 0;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = StringsKt.contains$default((CharSequence)pageSource, (CharSequence)"<html", (boolean)false, (int)2, null);
            n = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "pageSource doesn't contain '<html': " + pageSource;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CharSequence charSequence = pageSource;
            n = StringsKt.indexOf$default((CharSequence)pageSource, (String)"<html", (int)0, (boolean)false, (int)6, null);
            bl2 = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string2;
            String string3 = WHITESPACE_TEMPLATE;
            bl2 = false;
            string3 = new Regex(string3);
            String string4 = "";
            boolean bl5 = false;
            String string5 = string3.replace(charSequence, string4);
            String string6 = pageSourcePretty;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"pageSourcePretty");
            charSequence = string6;
            int n2 = StringsKt.indexOf$default((CharSequence)pageSourcePretty, (String)"<html", (int)0, (boolean)false, (int)6, null);
            boolean bl6 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = ((String)charSequence2).substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string7;
            String string8 = WHITESPACE_TEMPLATE;
            bl6 = false;
            string8 = new Regex(string8);
            String string9 = "";
            bl5 = false;
            Intrinsics.areEqual((Object)string5, (Object)string8.replace(charSequence, string9));
        } else {
            CharSequence charSequence = pageSource;
            String string = WHITESPACE_TEMPLATE;
            boolean bl = false;
            string = new Regex(string);
            String string10 = "";
            boolean bl7 = false;
            String string11 = string.replace(charSequence, string10);
            String string12 = pageSourcePretty;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"pageSourcePretty");
            charSequence = string12;
            string = WHITESPACE_TEMPLATE;
            boolean bl8 = false;
            string = new Regex(string);
            String string13 = "";
            bl7 = false;
            Intrinsics.areEqual((Object)string11, (Object)string.replace(charSequence, string13));
        }
        return pageSourcePretty;
    }

    public final <V> void webDriverWait(@NotNull WebDriver browser, @NotNull Function<? super WebDriver, V> condition) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.webDriverWait(browser, condition, NO_DESCRIPTION);
    }

    public final <V> void webDriverWait(@NotNull WebDriver browser, @NotNull Function<? super WebDriver, V> condition, @NotNull String exceptionScreenshotDescription) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)exceptionScreenshotDescription, (String)"exceptionScreenshotDescription");
        this.webDriverWait(browser, condition, exceptionScreenshotDescription, this.webDriverWaitTimeout);
    }

    public final <V> void webDriverWait(@NotNull WebDriver browser, @NotNull Function<? super WebDriver, V> condition, @NotNull String exceptionScreenshotDescription, int overrideWebDriverWaitTimout) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)exceptionScreenshotDescription, (String)"exceptionScreenshotDescription");
        this.webDriverWait(browser, condition, exceptionScreenshotDescription, overrideWebDriverWaitTimout, WaitExceptionActions.INSTANCE.screenshot());
    }

    public final <V> void webDriverWait(@NotNull WebDriver browser, @NotNull Function<? super WebDriver, V> condition, @NotNull String exceptionDescription, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)exceptionDescription, (String)"exceptionDescription");
        Intrinsics.checkNotNullParameter((Object)waitExceptionActions, (String)"waitExceptionActions");
        this.webDriverWait(browser, condition, exceptionDescription, this.webDriverWaitTimeout, Arrays.copyOf(waitExceptionActions, waitExceptionActions.length));
    }

    public final <V> void webDriverWait(@NotNull WebDriver browser, @NotNull Function<? super WebDriver, V> condition, @NotNull String exceptionDescription, int overrideWebDriverWaitTimout, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)exceptionDescription, (String)"exceptionDescription");
        Intrinsics.checkNotNullParameter((Object)waitExceptionActions, (String)"waitExceptionActions");
        try {
            this.createWebDriverWait(browser, overrideWebDriverWaitTimout).until(condition);
        }
        catch (TimeoutException ex) {
            LOGGER.trace("WebDriverWait timed out, performing actions " + waitExceptionActions + ", see nested " + "exception for details", (Throwable)ex);
            this.handleWaitException(browser, "web driver wait timeout exception for element '" + exceptionDescription + '\'', Arrays.copyOf(waitExceptionActions, waitExceptionActions.length));
            throw (Throwable)ex;
        }
        catch (NoSuchElementException ex) {
            LOGGER.trace("NoSuchElementException occured, made screenshot, see nested exception for details", (Throwable)ex);
            this.handleWaitException(browser, "web driver wait no-such-element exception for element '" + exceptionDescription + '\'', Arrays.copyOf(waitExceptionActions, waitExceptionActions.length));
            throw (Throwable)ex;
        }
    }

    public final void handleWaitException(@NotNull WebDriver browser, @NotNull String description, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)waitExceptionActions, (String)"waitExceptionActions");
        for (WaitExceptionAction waitExceptionAction : waitExceptionActions) {
            waitExceptionAction.perform(this, browser, description);
        }
    }

    @NotNull
    protected FluentWait<WebDriver> createFluentWait(@NotNull WebDriver webDriver) {
        Intrinsics.checkNotNullParameter((Object)webDriver, (String)"webDriver");
        return new FluentWait((Object)webDriver);
    }

    @NotNull
    protected WebDriverWait createWebDriverWait(@NotNull WebDriver webDriver, long timeOutInSeconds) {
        Intrinsics.checkNotNullParameter((Object)webDriver, (String)"webDriver");
        return new WebDriverWait(webDriver, timeOutInSeconds);
    }

    @JvmOverloads
    public SeleniumHelper(@NotNull String screenshotStartMarker, @NotNull String screeenshotEndMarker, @NotNull String pageSourceStartMarker, @NotNull String pageSourceEndMarker, int webDriverWaitTimeout, @NotNull File screenshotDir, @NotNull ValidationService validationService) {
        Intrinsics.checkNotNullParameter((Object)screenshotStartMarker, (String)"screenshotStartMarker");
        Intrinsics.checkNotNullParameter((Object)screeenshotEndMarker, (String)"screeenshotEndMarker");
        Intrinsics.checkNotNullParameter((Object)pageSourceStartMarker, (String)"pageSourceStartMarker");
        Intrinsics.checkNotNullParameter((Object)pageSourceEndMarker, (String)"pageSourceEndMarker");
        Intrinsics.checkNotNullParameter((Object)screenshotDir, (String)"screenshotDir");
        Intrinsics.checkNotNullParameter((Object)validationService, (String)"validationService");
        this.screenshotStartMarker = screenshotStartMarker;
        this.screenshotEndMarker = screeenshotEndMarker;
        this.pageSourceStartMarker = pageSourceStartMarker;
        this.pageSourceEndMarker = pageSourceEndMarker;
        if (!screenshotDir.exists()) {
            Files.createDirectories(screenshotDir.toPath(), new FileAttribute[0]);
        } else if (screenshotDir.exists()) {
            if (!screenshotDir.isDirectory()) {
                throw (Throwable)new IllegalArgumentException("screenshot directory '" + screenshotDir.getAbsolutePath() + "' points to an " + "existing path which is not a directory");
            }
            if (screenshotDir.list().length != 0) {
                throw (Throwable)new IllegalArgumentException("screenshot directory '" + screenshotDir.getAbsolutePath() + "' points to an " + "existing directory which is not empty");
            }
        }
        this.screenshotDir = screenshotDir;
        LOGGER.info("screenshot directory is '" + screenshotDir.getAbsolutePath() + '\'');
        this.webDriverWaitTimeout = webDriverWaitTimeout;
        this.validationService = validationService;
    }

    public /* synthetic */ SeleniumHelper(String string, String string2, String string3, String string4, int n, File file, ValidationService validationService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            validationService = (ValidationService)new MemoryValidationService(true, null, 2, null);
        }
        this(string, string2, string3, string4, n, file, validationService);
    }

    @JvmOverloads
    public SeleniumHelper(@NotNull String screenshotStartMarker, @NotNull String screeenshotEndMarker, @NotNull String pageSourceStartMarker, @NotNull String pageSourceEndMarker, int webDriverWaitTimeout, @NotNull File screenshotDir) {
        this(screenshotStartMarker, screeenshotEndMarker, pageSourceStartMarker, pageSourceEndMarker, webDriverWaitTimeout, screenshotDir, null, 64, null);
    }

    @JvmOverloads
    public SeleniumHelper(int webDriverWaitTimeout) {
        File file = Files.createTempDirectory("selenium-helper-screenshots", new FileAttribute[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Files.createTempDirector\u2026er-screenshots\").toFile()");
        this("---", "---", "===", "===", webDriverWaitTimeout, file, null, 64, null);
    }

    public /* synthetic */ SeleniumHelper(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        this(n);
    }

    @JvmOverloads
    public SeleniumHelper() {
        this(0, 1, null);
    }

    public SeleniumHelper(@NotNull File screenshotDir) {
        Intrinsics.checkNotNullParameter((Object)screenshotDir, (String)"screenshotDir");
        this("---", "---", "===", "===", 5, screenshotDir, null, 64, null);
    }

    public SeleniumHelper(int webDriverWaitTimeout, @NotNull File screenshotDir) {
        Intrinsics.checkNotNullParameter((Object)screenshotDir, (String)"screenshotDir");
        this("---", "---", "===", "===", webDriverWaitTimeout, screenshotDir, null, 64, null);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(SeleniumHelper.class);
        MISSING_DOCTYPE_MESSAGE_MATCHER = (Matcher)new MessageValidatorMessageMatcher("Start tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
    }

    @JvmStatic
    @NotNull
    public static final String randomString(int length) {
        return Companion.randomString(length);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lde/richtercloud/selenium/tools/SeleniumHelper$TextToBePresentInElementWithText;", "Lorg/openqa/selenium/support/ui/ExpectedCondition;", "", "element", "Lorg/openqa/selenium/WebElement;", "text", "", "(Lde/richtercloud/selenium/tools/SeleniumHelper;Lorg/openqa/selenium/WebElement;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "apply", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)Ljava/lang/Boolean;", "toString", "selenium-tools"})
    public final class TextToBePresentInElementWithText
    implements ExpectedCondition<Boolean> {
        private final WebElement element;
        @NotNull
        private final String text;

        @Nullable
        public Boolean apply(@Nullable WebDriver driver) {
            return (Boolean)ExpectedConditions.textToBePresentInElement((WebElement)this.element, (String)this.text).apply((Object)driver);
        }

        @NotNull
        public String toString() {
            return ExpectedConditions.textToBePresentInElement((WebElement)this.element, (String)this.text).toString();
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        protected TextToBePresentInElementWithText(@NotNull WebElement element, String text) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.element = element;
            this.text = text;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020\u00042\n\u0010(\u001a\u00020)\"\u00020\u0019H\u0002J/\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040,0+2\u0016\u0010-\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040.\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010/J\"\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040,0+2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000100J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0019H\u0007J\u000e\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205J\u001a\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001f2\n\u0010(\u001a\u00020)\"\u00020\u0019J \u00108\u001a\b\u0012\u0004\u0012\u00020\u001f0,2\u0006\u00107\u001a\u00020\u001f2\n\u0010(\u001a\u00020)\"\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lde/richtercloud/selenium/tools/SeleniumHelper$Companion;", "", "()V", "DOCTYPE_TEMPLATE", "", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOG_DESCRIPTION_DOM_TREE", "LOG_DESCRIPTION_PAGE_SOURCE", "MISSING_DOCTYPE_MESSAGE_MATCHER", "Lcom/natpryce/hamkrest/Matcher;", "Lde/richtercloud/jsf/validation/service/ValidatorMessage;", "getMISSING_DOCTYPE_MESSAGE_MATCHER", "()Lcom/natpryce/hamkrest/Matcher;", "NO_DESCRIPTION", "PAGE_SOURCE_END_MARKER_DEFAULT", "PAGE_SOURCE_START_MARKER_DEFAULT", "SCREENSHOT_END_MARKER_DEFAULT", "SCREENSHOT_OUTPUT_MODE_BASE64", "SCREENSHOT_OUTPUT_MODE_BASE64_GZIP", "SCREENSHOT_OUTPUT_MODE_FILE", "SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME", "SCREENSHOT_START_MARKER_DEFAULT", "WEB_DRIVER_WAIT_TIMEOUT_DEFAULT", "", "WHITESPACE_TEMPLATE", "absenceOfWebElement", "Lorg/openqa/selenium/support/ui/ExpectedCondition;", "", "webElement", "Lorg/openqa/selenium/WebElement;", "assertResponseCodeEquals", "", "responseCode", "uRLConnection", "Ljava/net/HttpURLConnection;", "httpResponse", "Lorg/apache/http/HttpResponse;", "buildXPathForSlideMenuIndices", "indices", "", "createMessagePermutation", "", "", "texts", "", "([Ljava/lang/String;)Ljava/util/Set;", "", "randomString", "length", "retrievePlainText", "browser", "Lorg/openqa/selenium/WebDriver;", "retrieveSlideMenuItem", "slideMenu", "retrieveSlideMenuItems", "selenium-tools"})
    public static final class Companion {
        @NotNull
        public final Matcher<ValidatorMessage> getMISSING_DOCTYPE_MESSAGE_MATCHER() {
            return MISSING_DOCTYPE_MESSAGE_MATCHER;
        }

        @JvmStatic
        @NotNull
        public final String randomString(int length) {
            boolean bl = length > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "length mustn't be <= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = RandomStringUtils.randomAlphanumeric((int)length);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RandomStringUtils.randomAlphanumeric(length)");
            return string;
        }

        @NotNull
        public final String retrievePlainText(@NotNull WebDriver browser) {
            WebElement preElement;
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            WebElement webElement = preElement = browser.findElement(By.xpath((String)"/html/body/pre"));
            Intrinsics.checkNotNullExpressionValue((Object)webElement, (String)"preElement");
            String string = webElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"preElement.text");
            return string;
        }

        @NotNull
        public final Set<List<String>> createMessagePermutation(@Nullable Collection<String> texts) {
            Set retValue = new HashSet();
            PermutationIterator textsPermutationIterator = new PermutationIterator(texts);
            textsPermutationIterator.forEachRemaining((Consumer)new Consumer<List<String>>(retValue){
                final /* synthetic */ Set $retValue;

                public final void accept(@NotNull List<String> perm) {
                    Intrinsics.checkNotNullParameter(perm, (String)"perm");
                    this.$retValue.add(perm);
                }
                {
                    this.$retValue = set;
                }
            });
            return retValue;
        }

        @NotNull
        public final Set<List<String>> createMessagePermutation(String ... texts) {
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            return this.createMessagePermutation(new HashSet(Arrays.asList(Arrays.copyOf(texts, texts.length))));
        }

        public final void assertResponseCodeEquals(int responseCode, @NotNull HttpResponse httpResponse) throws IOException {
            Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
            StatusLine statusLine = httpResponse.getStatusLine();
            Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"httpResponse.statusLine");
            if (responseCode != statusLine.getStatusCode()) {
                throw (Throwable)new ResponseCodeUnequalsException(httpResponse);
            }
        }

        public final void assertResponseCodeEquals(int responseCode, @NotNull HttpURLConnection uRLConnection) throws IOException {
            Intrinsics.checkNotNullParameter((Object)uRLConnection, (String)"uRLConnection");
            if (responseCode != uRLConnection.getResponseCode()) {
                throw (Throwable)new ResponseCodeUnequalsException(uRLConnection);
            }
        }

        @NotNull
        public final WebElement retrieveSlideMenuItem(@NotNull WebElement slideMenu, int ... indices) {
            Intrinsics.checkNotNullParameter((Object)slideMenu, (String)"slideMenu");
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            String xPath = this.buildXPathForSlideMenuIndices(Arrays.copyOf(indices, indices.length));
            WebElement webElement = slideMenu.findElement(By.xpath((String)xPath));
            Intrinsics.checkNotNullExpressionValue((Object)webElement, (String)"slideMenu.findElement(By.xpath(xPath))");
            return webElement;
        }

        @NotNull
        public final List<WebElement> retrieveSlideMenuItems(@NotNull WebElement slideMenu, int ... indices) {
            Intrinsics.checkNotNullParameter((Object)slideMenu, (String)"slideMenu");
            Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
            String xPath = this.buildXPathForSlideMenuIndices(Arrays.copyOf(indices, indices.length));
            List list = slideMenu.findElements(By.xpath((String)xPath));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"slideMenu.findElements(By.xpath(xPath))");
            return list;
        }

        private final String buildXPathForSlideMenuIndices(int ... indices) {
            StringBuilder xPathBuilder = new StringBuilder(128);
            xPathBuilder.append("div/div[1]/");
            for (int index : indices) {
                xPathBuilder.append("ul/li[" + index + "]/");
            }
            xPathBuilder.append('a');
            String string = xPathBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xPathBuilder.toString()");
            String xPath = string;
            LOGGER.trace("buildXPathForSlideMenuIndices xPath: {}", (Object)xPath);
            return xPath;
        }

        @NotNull
        public final ExpectedCondition<Boolean> absenceOfWebElement(@NotNull WebElement webElement) {
            Intrinsics.checkNotNullParameter((Object)webElement, (String)"webElement");
            return (ExpectedCondition)new ExpectedCondition<Boolean>(webElement){
                final /* synthetic */ WebElement $webElement;

                @Nullable
                public final Boolean apply(@Nullable WebDriver f) {
                    boolean bl;
                    try {
                        this.$webElement.isDisplayed();
                        bl = false;
                    }
                    catch (NoSuchElementException ex) {
                        bl = true;
                    }
                    return bl;
                }
                {
                    this.$webElement = webElement;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

