/**
 * Copyright 2018 Karl-Philipp Richter
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.richtercloud.selenium.tools;

import org.openqa.selenium.WebDriver;

/**
 * Values represent different actions to take on exceptions during waiting for conditions.
 */
@FunctionalInterface
public interface WaitExceptionAction {

    void perform(SeleniumHelper seleniumHelper, WebDriver webDriver, String description) throws WebDriverWaitException;
}
