/**
 * Copyright 2018 Karl-Philipp Richter
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package de.richtercloud.selenium.tools;

import java.util.List;

/**
 *
 * @author richter
 */
public class PageSourceInvalidException extends Exception {
    private static final long serialVersionUID = 1L;

    /**
     * Creates a new page source invalid exception using {@code violations} to
     * construct the exception message.
     * @param violations the violations contained in the exception message
     */
    /*
    internal implementation notes:
    - can't provide a constructor with List<ValidatorResponseMessage> because
    it'd have the same type erasure as List<String>
    */
    public PageSourceInvalidException(List<String> violations) {
        super(String.format("The page source has the following validity violations: %s",
                violations));
    }
}
