/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.selenium.tools;

import de.richtercloud.jsf.validation.service.MemoryValidationService;
import de.richtercloud.jsf.validation.service.MessageValidatorMessageMatcher;
import de.richtercloud.jsf.validation.service.ValidationService;
import de.richtercloud.jsf.validation.service.ValidatorMessage;
import de.richtercloud.jsf.validation.service.ValidatorMessageSeverity;
import de.richtercloud.selenium.tools.MessageTextNotContainedException;
import de.richtercloud.selenium.tools.PageSourceInvalidException;
import de.richtercloud.selenium.tools.ResponseCodeUnequalsException;
import de.richtercloud.selenium.tools.WaitExceptionAction;
import de.richtercloud.selenium.tools.WaitExceptionActions;
import de.richtercloud.selenium.tools.WebDriverWaitException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.iterators.PermutationIterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ru.yandex.qatools.ashot.AShot;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.shooting.ShootingStrategies;

public class SeleniumHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeleniumHelper.class);
    private static final String SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME = "screenshotOutputMode";
    private static final String SCREENSHOT_OUTPUT_MODE_FILE = "file";
    private static final String SCREENSHOT_OUTPUT_MODE_BASE64 = "base64";
    private static final String SCREENSHOT_OUTPUT_MODE_BASE64_GZIP = "base64-gzip";
    private static final String NO_DESCRIPTION = "no description";
    private static final String DOCTYPE_TEMPLATE = "<!DOCTYPE html>";
    private static final String WHITESPACE_TEMPLATE = "\\s+";
    public static final String SCREENSHOT_START_MARKER_DEFAULT = "---";
    public static final String SCREENSHOT_END_MARKER_DEFAULT = "---";
    public static final String PAGE_SOURCE_START_MARKER_DEFAULT = "===";
    public static final String PAGE_SOURCE_END_MARKER_DEFAULT = "===";
    public static final int WEB_DRIVER_WAIT_TIMEOUT_DEFAULT = 5;
    private static final String LOG_DESCRIPTION_PAGE_SOURCE = "browser page source";
    private static final String LOG_DESCRIPTION_DOM_TREE = "DOM tree";
    public static final Matcher MISSING_DOCTYPE_MESSAGE_MATCHER = new MessageValidatorMessageMatcher("Start tag seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
    private final File screenshotDir;
    private int screenshotCounter;
    private final String screenshotStartMarker;
    private final String screenshotEndMarker;
    private final String pageSourceStartMarker;
    private final String pageSourceEndMarker;
    private final int webDriverWaitTimeout;
    private final ValidationService validationService;

    public SeleniumHelper() throws IOException {
        this(5);
    }

    public SeleniumHelper(int webDriverWaitTimeout) throws IOException {
        this("---", "---", "===", "===", webDriverWaitTimeout, Files.createTempDirectory("selenium-helper-screenshots", new FileAttribute[0]).toFile());
    }

    public SeleniumHelper(File screenshotDir) throws IOException {
        this("---", "---", "===", "===", 5, screenshotDir);
    }

    public SeleniumHelper(int webDriverWaitTimeout, File screenshotDir) throws IOException {
        this("---", "---", "===", "===", webDriverWaitTimeout, screenshotDir);
    }

    public SeleniumHelper(String screenshotStartMarker, String screeenshotEndMarker, String pageSourceStartMarker, String pageSourceEndMarker, int webDriverWaitTimeout, File screenshotDir) throws IOException {
        this(screenshotStartMarker, screeenshotEndMarker, pageSourceStartMarker, pageSourceEndMarker, webDriverWaitTimeout, screenshotDir, (ValidationService)new MemoryValidationService(true));
    }

    protected SeleniumHelper(String screenshotStartMarker, String screeenshotEndMarker, String pageSourceStartMarker, String pageSourceEndMarker, int webDriverWaitTimeout, File screenshotDir, ValidationService validationService) throws IOException {
        if (screenshotStartMarker == null) {
            throw new IllegalArgumentException("screenshotStartMarker mustn't be null");
        }
        this.screenshotStartMarker = screenshotStartMarker;
        if (screeenshotEndMarker == null) {
            throw new IllegalArgumentException("screeenshotEndMarker mustn't be null");
        }
        this.screenshotEndMarker = screeenshotEndMarker;
        if (pageSourceStartMarker == null) {
            throw new IllegalArgumentException("pageSourceStartMarker mustn't be null");
        }
        this.pageSourceStartMarker = pageSourceStartMarker;
        if (pageSourceEndMarker == null) {
            throw new IllegalArgumentException("pageSourceEndMarker mustn't be null");
        }
        this.pageSourceEndMarker = pageSourceEndMarker;
        if (screenshotDir == null) {
            throw new IllegalArgumentException("screenshotDir mustn't be null");
        }
        if (!screenshotDir.exists()) {
            Files.createDirectories(screenshotDir.toPath(), new FileAttribute[0]);
        } else if (screenshotDir.exists()) {
            if (!screenshotDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("screenshot directory '%s' points to an existing path which is not a directory", screenshotDir.getAbsolutePath()));
            }
            if (screenshotDir.list().length != 0) {
                throw new IllegalArgumentException(String.format("screenshot directory '%s' points to an existing directory which is not empty", screenshotDir.getAbsolutePath()));
            }
        }
        this.screenshotDir = screenshotDir;
        LOGGER.info(String.format("screenshot directory is '%s'", screenshotDir.getAbsolutePath()));
        this.webDriverWaitTimeout = webDriverWaitTimeout;
        this.validationService = validationService;
    }

    public static String randomString(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length mustn't be <= 0");
        }
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public String retrieveMessagesText(WebDriver browser, WebElement messages) throws WebDriverWaitException {
        return this.retrieveMessagesText(browser, messages, null, false);
    }

    private String retrieveMessagesText(WebDriver browser, WebElement messages, String expectedText, boolean waitForExpectedText) throws WebDriverWaitException {
        LOGGER.trace(String.format("retrieveMessagesText expectedText: %s", expectedText));
        LOGGER.trace(String.format("retrieveMessagesText messages.text: %s", messages.getText()));
        this.webDriverWait(browser, (Function)ExpectedConditions.visibilityOf((WebElement)messages));
        if (expectedText != null) {
            if (waitForExpectedText) {
                try {
                    this.webDriverWait(browser, (Function)ExpectedConditions.textToBePresentInElement((WebElement)messages, (String)expectedText));
                }
                catch (TimeoutException ex) {
                    throw new MessageTextNotContainedException(expectedText, messages.getText());
                }
            }
            if (!expectedText.equals(messages.getText())) {
                throw new MessageTextNotContainedException(expectedText, messages.getText());
            }
        }
        String retValue = messages.getText();
        assert (expectedText == null || expectedText.equals(retValue)) : String.format("expectedText '%s' is not equal to retValue '%s'", expectedText, retValue);
        return retValue;
    }

    public static String retrievePlainText(WebDriver browser) {
        WebElement preElement = browser.findElement(By.xpath((String)"/html/body/pre"));
        return preElement.getText();
    }

    public void assertMessagesContains(WebDriver browser, WebElement messages, String messageText) throws WebDriverWaitException {
        this.assertMessagesContains(browser, messages, messageText, false);
    }

    public void assertMessagesContains(WebDriver browser, WebElement messages, String messageText, boolean waitForMessageText) throws WebDriverWaitException {
        this.webDriverWait(browser, (Function)ExpectedConditions.visibilityOf((WebElement)messages));
        String messagesText = this.retrieveMessagesText(browser, messages, messageText, waitForMessageText);
        assert (messageText.equals(messagesText));
    }

    public void assertMessagesContainsAny(WebDriver browser, WebElement messages, Set<String> texts) throws WebDriverWaitException {
        if (browser == null) {
            throw new IllegalArgumentException("browser mustn't be null");
        }
        if (messages == null) {
            throw new IllegalArgumentException("messages mustn't be null");
        }
        if (texts == null) {
            throw new IllegalArgumentException("texts mustn't be null");
        }
        if (texts.isEmpty()) {
            throw new IllegalArgumentException("texts mustn't be empty");
        }
        if (texts.contains(null)) {
            throw new IllegalArgumentException("texts mustn't contain null");
        }
        Iterator<String> textsItr = texts.iterator();
        String text = textsItr.next();
        try {
            this.retrieveMessagesText(browser, messages, text, true);
            return;
        }
        catch (MessageTextNotContainedException ex) {
            String messagesText = this.retrieveMessagesText(browser, messages, null, false);
            while (textsItr.hasNext()) {
                text = textsItr.next();
                if (!text.equals(messagesText)) continue;
                return;
            }
            LOGGER.trace(String.format("messages.innerHTML: %s", messages.getAttribute("innerHTML")));
            throw new MessageTextNotContainedException(texts, messages.getText());
        }
    }

    public static Set<List<String>> createMessagePermutation(Collection<String> texts) {
        HashSet<List<String>> retValue = new HashSet<List<String>>();
        PermutationIterator textsPermutationIterator = new PermutationIterator(texts);
        textsPermutationIterator.forEachRemaining(perm -> retValue.add((List<String>)perm));
        return retValue;
    }

    public static Set<List<String>> createMessagePermutation(String ... texts) {
        return SeleniumHelper.createMessagePermutation(new HashSet<String>(Arrays.asList(texts)));
    }

    private String compressGzipAndEncodeBytes(byte[] screenshotBytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        ByteArrayInputStream screenshotBytesInputStream = new ByteArrayInputStream(screenshotBytes);
        IOUtils.copy((InputStream)screenshotBytesInputStream, (OutputStream)gZIPOutputStream);
        byte[] compressedScreenshotBytes = byteArrayOutputStream.toByteArray();
        return Base64.getEncoder().encodeToString(compressedScreenshotBytes);
    }

    public void screenshot(WebDriver browser) throws WebDriverWaitException {
        this.screenshot(browser, NO_DESCRIPTION);
    }

    public void screenshot(WebDriver browser, String description) throws WebDriverWaitException {
        if (browser == null) {
            throw new IllegalArgumentException("browser mustn't be null");
        }
        if (!(browser instanceof TakesScreenshot)) {
            LOGGER.debug("browser doesn't support taking screenshots");
            return;
        }
        if (description == null) {
            throw new IllegalArgumentException("description mustn't be null");
        }
        String screenshotOutputMode = System.getProperty(SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME, SCREENSHOT_OUTPUT_MODE_FILE);
        assert (screenshotOutputMode != null);
        switch (screenshotOutputMode) {
            case "file": {
                File scrFile = (File)((TakesScreenshot)browser).getScreenshotAs(OutputType.FILE);
                try {
                    FileUtils.copyFile((File)scrFile, (File)new File(this.screenshotDir, this.generateScreenshotFilename(this.screenshotCounter, description)));
                    break;
                }
                catch (IOException ex) {
                    throw new WebDriverWaitException(ex);
                }
            }
            case "base64": {
                String screenshotBase64 = (String)((TakesScreenshot)browser).getScreenshotAs(OutputType.BASE64);
                LOGGER.info(String.format("base64 encoding of screenshot with description '%s':\n%s\n%s\n%s", description, this.screenshotStartMarker, screenshotBase64, this.screenshotEndMarker));
                break;
            }
            case "base64-gzip": {
                String compressedScreenshotBase64;
                byte[] screenshotBytes = (byte[])((TakesScreenshot)browser).getScreenshotAs(OutputType.BYTES);
                try {
                    compressedScreenshotBase64 = this.compressGzipAndEncodeBytes(screenshotBytes);
                }
                catch (IOException ex) {
                    throw new WebDriverWaitException(ex);
                }
                LOGGER.info(String.format("gzip compresed base64 encoding of screenshot with description '%s':\n%s\n%s\n%s", description, this.screenshotStartMarker, compressedScreenshotBase64, this.screenshotEndMarker));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Illegal value '%s' specified for property %s", screenshotOutputMode, SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME));
            }
        }
        ++this.screenshotCounter;
    }

    public void screenshotFullPage(WebDriver browser) throws WebDriverWaitException {
        this.screenshotFullPage(browser, NO_DESCRIPTION);
    }

    public void screenshotFullPage(WebDriver browser, String description) throws WebDriverWaitException {
        String screenshotOutputMode = System.getProperty(SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME, SCREENSHOT_OUTPUT_MODE_FILE);
        assert (screenshotOutputMode != null);
        switch (screenshotOutputMode) {
            case "file": {
                Screenshot fpScreenshot = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", new File(this.screenshotDir, this.generateScreenshotFilename(this.screenshotCounter, description)));
                    break;
                }
                catch (IOException ex) {
                    throw new WebDriverWaitException(ex);
                }
            }
            case "base64": {
                Screenshot fpScreenshot = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                ByteArrayOutputStream imageOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", imageOutputStream);
                }
                catch (IOException ex) {
                    throw new WebDriverWaitException(ex);
                }
                String screenshotBase64 = Base64.getEncoder().encodeToString(imageOutputStream.toByteArray());
                LOGGER.info(String.format("base64 encoding of screenshot with description '%s':\n%s\n%s\n%s", description, this.screenshotStartMarker, screenshotBase64, this.screenshotEndMarker));
                break;
            }
            case "base64-gzip": {
                Screenshot fpScreenshot = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)1000)).takeScreenshot(browser);
                ByteArrayOutputStream imageOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)fpScreenshot.getImage(), "PNG", imageOutputStream);
                    String compressedScreenshotBase64 = this.compressGzipAndEncodeBytes(imageOutputStream.toByteArray());
                    LOGGER.info(String.format("gzip compresed base64 encoding of screenshot with description '%s':\n%s\n%s\n%s", description, this.screenshotStartMarker, compressedScreenshotBase64, this.screenshotEndMarker));
                    break;
                }
                catch (IOException ex) {
                    throw new WebDriverWaitException(ex);
                }
            }
            default: {
                throw new IllegalArgumentException(String.format("Illegal value '%s' specified for property %s", screenshotOutputMode, SCREENSHOT_OUTPUT_MODE_PROPERTY_NAME));
            }
        }
        ++this.screenshotCounter;
    }

    private String generateScreenshotFilename(int screenshotCounter, String description) {
        return String.format("%05d-%s.png", screenshotCounter, description);
    }

    public void validatePageSource(String pageSource, ValidatorMessageSeverity minimumLevel, Matcher<ValidatorMessage> ignore) throws SAXException, IOException, PageSourceInvalidException {
        List violations = this.validationService.validateMessages((InputStream)new ByteArrayInputStream(pageSource.getBytes()), minimumLevel, ignore);
        if (!violations.isEmpty()) {
            throw new PageSourceInvalidException(ValidationService.transformValidatorResponse((List)violations));
        }
    }

    public void validatePageSource(String pageSource, ValidatorMessageSeverity minimumLevel) throws SAXException, IOException, PageSourceInvalidException {
        this.validatePageSource(pageSource, minimumLevel, (Matcher<ValidatorMessage>)MISSING_DOCTYPE_MESSAGE_MATCHER);
    }

    public void validatePageSource(String pageSource) throws SAXException, IOException, PageSourceInvalidException {
        this.validatePageSource(pageSource, ValidatorMessageSeverity.WARNING);
    }

    public void logPageSource(WebDriver browser, Logger logger) {
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, browser.getPageSource(), logger);
    }

    public void logPageSourcePretty(WebDriver browser, Logger logger) throws WebDriverWaitException {
        this.logPageSourcePretty(browser, logger, ValidatorMessageSeverity.WARNING, (Matcher<ValidatorMessage>)CoreMatchers.not((Matcher)CoreMatchers.anything()));
    }

    public void logPageSourcePretty(WebDriver browser, Logger logger, ValidatorMessageSeverity validationMinimumLevel, Matcher<ValidatorMessage> ignore) throws WebDriverWaitException {
        String pageSource = browser.getPageSource();
        try {
            this.validatePageSource(pageSource, validationMinimumLevel, ignore);
        }
        catch (PageSourceInvalidException | IOException | SAXException ex) {
            throw new WebDriverWaitException(ex);
        }
        String pageSourcePretty = this.prettyPrintPageSource(pageSource);
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, pageSourcePretty, logger);
    }

    public void logPageSourceURLPretty(URL url, Logger logger, ValidatorMessageSeverity validationMinimumLevel, Matcher<ValidatorMessage> ignore) throws IOException, SAXException, PageSourceInvalidException {
        String pageSource = IOUtils.toString((URL)url, (Charset)Charset.defaultCharset());
        this.validatePageSource(pageSource, validationMinimumLevel, ignore);
        String pageSourcePretty = this.prettyPrintPageSource(pageSource);
        this.logPageSource(LOG_DESCRIPTION_PAGE_SOURCE, pageSourcePretty, logger);
    }

    private void logPageSource(String description, String pageSource, Logger logger) {
        logger.info(String.format("%s:\n%s\n%s\n%s", description, this.pageSourceStartMarker, pageSource, this.pageSourceEndMarker));
    }

    public void logDOMTree(JavascriptExecutor browser, Logger logger) throws ParserConfigurationException, SAXException, IOException {
        String htmlOuterHtml = (String)browser.executeScript("return document.childNodes[1].outerHTML;", new Object[0]);
        String pageSourcePretty = this.prettyPrintPageSource(htmlOuterHtml);
        this.logPageSource(LOG_DESCRIPTION_DOM_TREE, pageSourcePretty, logger);
    }

    private String prettyPrintPageSource(String pageSource) {
        Document doc = Jsoup.parse((String)pageSource);
        doc.outputSettings().prettyPrint(true);
        String pageSourcePretty = doc.html();
        if (StringUtils.startsWithIgnoreCase((CharSequence)pageSource, (CharSequence)DOCTYPE_TEMPLATE)) {
            assert (StringUtils.startsWithIgnoreCase((CharSequence)pageSource, (CharSequence)DOCTYPE_TEMPLATE));
            assert (pageSource.contains("<html")) : String.format("pageSource doesn't contain '<html': %s", pageSource);
            pageSource.substring(pageSource.indexOf("<html")).replaceAll(WHITESPACE_TEMPLATE, "").equals(pageSourcePretty.substring(pageSourcePretty.indexOf("<html")).replaceAll(WHITESPACE_TEMPLATE, ""));
        } else {
            pageSource.replaceAll(WHITESPACE_TEMPLATE, "").equals(pageSourcePretty.replaceAll(WHITESPACE_TEMPLATE, ""));
        }
        return pageSourcePretty;
    }

    public <V> void webDriverWait(WebDriver browser, Function<? super WebDriver, V> condition) throws WebDriverWaitException {
        this.webDriverWait(browser, condition, NO_DESCRIPTION);
    }

    public <V> void webDriverWait(WebDriver browser, Function<? super WebDriver, V> condition, String exceptionScreenshotDescription) throws WebDriverWaitException {
        this.webDriverWait(browser, condition, exceptionScreenshotDescription, this.webDriverWaitTimeout);
    }

    public <V> void webDriverWait(WebDriver browser, Function<? super WebDriver, V> condition, String exceptionScreenshotDescription, int overrideWebDriverWaitTimout) throws WebDriverWaitException {
        this.webDriverWait(browser, condition, exceptionScreenshotDescription, overrideWebDriverWaitTimout, WaitExceptionActions.screenshot());
    }

    public <V> void webDriverWait(WebDriver browser, Function<? super WebDriver, V> condition, String exceptionDescription, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        this.webDriverWait(browser, condition, exceptionDescription, this.webDriverWaitTimeout, waitExceptionActions);
    }

    public <V> void webDriverWait(WebDriver browser, Function<? super WebDriver, V> condition, String exceptionDescription, int overrideWebDriverWaitTimout, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        try {
            this.createWebDriverWait(browser, overrideWebDriverWaitTimout).until(condition);
        }
        catch (TimeoutException ex) {
            LOGGER.trace(String.format("WebDriverWait timed out, performing actions %s, see nested exception for details", waitExceptionActions), (Throwable)ex);
            this.handleWaitException(browser, String.format("web driver wait timeout exception for element '%s'", exceptionDescription), waitExceptionActions);
            throw ex;
        }
        catch (NoSuchElementException ex) {
            LOGGER.trace("NoSuchElementException occured, made screenshot, see nested exception for details", (Throwable)ex);
            this.handleWaitException(browser, String.format("web driver wait no-such-element exception for element '%s'", exceptionDescription), waitExceptionActions);
            throw ex;
        }
    }

    void handleWaitException(WebDriver browser, String description, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        for (WaitExceptionAction waitExceptionAction : waitExceptionActions) {
            waitExceptionAction.perform(this, browser, description);
        }
    }

    public static void assertResponseCodeEquals(int responseCode, HttpResponse httpResponse) throws IOException {
        if (responseCode != httpResponse.getStatusLine().getStatusCode()) {
            throw new ResponseCodeUnequalsException(httpResponse);
        }
    }

    public static void assertResponseCodeEquals(int responseCode, HttpURLConnection uRLConnection) throws IOException {
        if (responseCode != uRLConnection.getResponseCode()) {
            throw new ResponseCodeUnequalsException(uRLConnection);
        }
    }

    public static WebElement retrieveSlideMenuItem(WebElement slideMenu, int ... indices) {
        String xPath = SeleniumHelper.buildXPathForSlideMenuIndices(indices);
        return slideMenu.findElement(By.xpath((String)xPath));
    }

    public static List<WebElement> retrieveSlideMenuItems(WebElement slideMenu, int ... indices) {
        String xPath = SeleniumHelper.buildXPathForSlideMenuIndices(indices);
        return slideMenu.findElements(By.xpath((String)xPath));
    }

    private static String buildXPathForSlideMenuIndices(int ... indices) {
        StringBuilder xPathBuilder = new StringBuilder(128);
        xPathBuilder.append("div/div[1]/");
        for (int index : indices) {
            xPathBuilder.append(String.format("ul/li[%d]/", index));
        }
        xPathBuilder.append('a');
        String xPath = xPathBuilder.toString();
        LOGGER.trace("buildXPathForSlideMenuIndices xPath: {}", (Object)xPath);
        return xPath;
    }

    public static ExpectedCondition<Boolean> absenceOfWebElement(WebElement webElement) {
        return f -> {
            try {
                webElement.isDisplayed();
                return false;
            }
            catch (NoSuchElementException ex) {
                return true;
            }
        };
    }

    protected FluentWait<WebDriver> createFluentWait(WebDriver webDriver) {
        return new FluentWait((Object)webDriver);
    }

    protected WebDriverWait createWebDriverWait(WebDriver webDriver, long timeOutInSeconds) {
        return new WebDriverWait(webDriver, timeOutInSeconds);
    }

    protected class TextToBePresentInElementWithText
    implements ExpectedCondition<Boolean> {
        private final WebElement element;
        private final String text;

        protected TextToBePresentInElementWithText(WebElement element, String text) {
            this.element = element;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public Boolean apply(WebDriver driver) {
            return (Boolean)ExpectedConditions.textToBePresentInElement((WebElement)this.element, (String)this.text).apply((Object)driver);
        }

        public String toString() {
            return ExpectedConditions.textToBePresentInElement((WebElement)this.element, (String)this.text).toString();
        }
    }
}

