/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.selenium.tools;

import de.richtercloud.selenium.tools.SeleniumHelper;
import de.richtercloud.selenium.tools.WaitExceptionAction;
import de.richtercloud.selenium.tools.WebDriverWaitException;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.openqa.selenium.WebDriver;

public final class SeleniumAssertionHelper {
    public static <T> void assertThat(T actual, Matcher condition, SeleniumHelper seleniumHelper, WebDriver webDriver, String description, WaitExceptionAction ... waitExceptionActions) throws WebDriverWaitException {
        if (condition == null) {
            throw new IllegalArgumentException("condition mustn't be null");
        }
        if (seleniumHelper == null) {
            throw new IllegalArgumentException("seleniumHelper mustn't be null");
        }
        if (webDriver == null) {
            throw new IllegalArgumentException("webDriver mustn't be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description mustn't be null");
        }
        if (waitExceptionActions == null || waitExceptionActions.length == 0) {
            throw new IllegalArgumentException("waitExceptionActions mustn't be null or empty");
        }
        if (ArrayUtils.contains((Object[])waitExceptionActions, null)) {
            throw new IllegalArgumentException("waitExceptionActions mustn't contain null");
        }
        try {
            MatcherAssert.assertThat(actual, (Matcher)condition);
        }
        catch (AssertionError err) {
            for (WaitExceptionAction waitExceptionAction : waitExceptionActions) {
                waitExceptionAction.perform(seleniumHelper, webDriver, description);
            }
            throw err;
        }
    }

    private SeleniumAssertionHelper() {
    }
}

