/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.typehandler;

import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.EditableListPanelItemListener;
import de.richtercloud.reflection.form.builder.panels.ListPanelItemEvent;
import de.richtercloud.reflection.form.builder.panels.SimpleEntityListPanel;
import de.richtercloud.reflection.form.builder.typehandler.AbstractListTypeHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEntityListTypeHandler
extends AbstractListTypeHandler<List<Object>, FieldUpdateEvent<List<Object>>, ReflectionFormBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEntityListTypeHandler.class);

    public SimpleEntityListTypeHandler(IssueHandler issueHandler) {
        super(issueHandler);
    }

    @Override
    public Pair<JComponent, ComponentHandler<?>> handle0(Type type, List<Object> fieldValue, final FieldUpdateListener<FieldUpdateEvent<List<Object>>> updateListener, ReflectionFormBuilder reflectionFormBuilder) {
        Class entityClass;
        LOGGER.debug("handling type {}", (Object)type);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getActualTypeArguments().length == 0) {
                entityClass = Object.class;
            } else if (parameterizedType.getActualTypeArguments().length > 1) {
                throw new IllegalArgumentException(String.format("can't handle more than one type argument with a %s (type is %s)", List.class, type));
            }
            Type listGenericType = parameterizedType.getActualTypeArguments()[0];
            if (!(listGenericType instanceof Class)) {
                throw new IllegalArgumentException(String.format("first type argument of type %s isn't an instance of %s", type, Class.class));
            }
            entityClass = (Class)listGenericType;
        } else {
            entityClass = Object.class;
        }
        SimpleEntityListPanel<Object> retValue = new SimpleEntityListPanel<Object>(reflectionFormBuilder, fieldValue, entityClass, (MessageHandler)this.getIssueHandler());
        retValue.addItemListener(new EditableListPanelItemListener<Object>(){

            @Override
            public void onItemAdded(ListPanelItemEvent<Object> event) {
                updateListener.onUpdate(new FieldUpdateEvent<LinkedList<Object>>(new LinkedList<Object>(event.getItem())));
            }

            @Override
            public void onItemRemoved(ListPanelItemEvent<Object> event) {
                updateListener.onUpdate(new FieldUpdateEvent<LinkedList<Object>>(new LinkedList<Object>(event.getItem())));
            }

            @Override
            public void onItemChanged(ListPanelItemEvent<Object> event) {
                updateListener.onUpdate(new FieldUpdateEvent<LinkedList<Object>>(new LinkedList<Object>(event.getItem())));
            }
        });
        return new ImmutablePair(retValue, (Object)this);
    }
}

