/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.typehandler;

import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.TypeHandler;
import java.lang.reflect.Type;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class NumberTypeHandler
implements TypeHandler<Number, FieldUpdateEvent<Number>, ReflectionFormBuilder, JSpinner> {
    private static final NumberTypeHandler INSTANCE = new NumberTypeHandler();

    public static NumberTypeHandler getInstance() {
        return INSTANCE;
    }

    protected NumberTypeHandler() {
    }

    @Override
    public Pair<JComponent, ComponentHandler<?>> handle(Type type, Number fieldValue, String fieldName, Class<?> declaringClass, final FieldUpdateListener<FieldUpdateEvent<Number>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        JSpinner retValue = new JSpinner(new SpinnerNumberModel(fieldValue, null, null, (Number)1));
        retValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Number>((Number)((JSpinner)e.getSource()).getValue()));
            }
        });
        return new ImmutablePair((Object)retValue, (Object)this);
    }

    @Override
    public void reset(JSpinner component) {
        component.setValue(0);
    }
}

