/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.typehandler;

import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.TypeHandler;
import java.awt.Component;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;

public class MappingTypeHandler<T, E extends FieldUpdateEvent<T>, R extends ReflectionFormBuilder>
implements TypeHandler<T, E, R, Component> {
    private final Map<Type, TypeHandler<T, E, R, Component>> classMapping = new HashMap<Type, TypeHandler<T, E, R, Component>>();
    private final Map<JComponent, ComponentHandler<?>> componentMapping = new HashMap();

    @Override
    public final Pair<JComponent, ComponentHandler<?>> handle(Type type, T fieldValue, String fieldName, Class<?> declaringClass, FieldUpdateListener<E> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        Pair<JComponent, ComponentHandler<?>> retValueEntry = this.handle0(type, fieldValue, fieldName, declaringClass, updateListener, reflectionFormBuilder);
        if (retValueEntry == null) {
            throw new IllegalArgumentException("handle0 mustn't return null");
        }
        ComponentHandler componentResettable = (ComponentHandler)retValueEntry.getValue();
        if (componentResettable == null) {
            throw new IllegalArgumentException("ComponentResettable in Pair returned by handle0 mustn't be null");
        }
        JComponent retValue = (JComponent)retValueEntry.getKey();
        this.componentMapping.put(retValue, componentResettable);
        return retValueEntry;
    }

    protected Pair<JComponent, ComponentHandler<?>> handle0(Type type, T fieldValue, String fieldName, Class<?> declaringClass, FieldUpdateListener<E> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        TypeHandler<T, E, R, Component> typeHandler = this.classMapping.get(type);
        if (typeHandler == null) {
            throw new IllegalArgumentException(String.format("Type '%s' isn't mapped.", type));
        }
        Pair<JComponent, ComponentHandler<?>> retValue = typeHandler.handle(type, fieldValue, fieldName, declaringClass, updateListener, reflectionFormBuilder);
        return retValue;
    }

    @Override
    public void reset(Component component) throws ResetException {
        ComponentHandler<?> componentResettable = this.componentMapping.get(component);
        componentResettable.reset(component);
    }
}

