/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.typehandler;

import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.TypeHandler;
import java.awt.Component;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GenericListTypeHandler<R extends ReflectionFormBuilder, C extends Component>
implements TypeHandler<List<Object>, FieldUpdateEvent<List<Object>>, R, C> {
    private final Map<Type, TypeHandler<?, ?, ?, ?>> genericsTypeHandlerMapping;
    private final Map<Type, TypeHandler<?, ?, ?, ?>> typeHandlerMapping;

    public GenericListTypeHandler(Map<Type, TypeHandler<?, ?, ?, ?>> genericsTypeHandlerMapping, Map<Type, TypeHandler<?, ?, ?, ?>> typeHandlerMapping) {
        this.genericsTypeHandlerMapping = genericsTypeHandlerMapping;
        this.typeHandlerMapping = typeHandlerMapping;
    }

    @Override
    public Pair<JComponent, ComponentHandler<?>> handle(Type type, List<Object> fieldValue, String fieldName, Class<?> declaringClass, FieldUpdateListener<FieldUpdateEvent<List<Object>>> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        TypeHandler<?, ?, ?, ?> fieldTypeHandler;
        List<Object> fieldValue0 = fieldValue;
        if (fieldValue0 == null) {
            fieldValue0 = new LinkedList<Object>();
        }
        if ((fieldTypeHandler = this.typeHandlerMapping.get(type)) != null) {
            Pair<JComponent, ComponentHandler<?>> retValue = fieldTypeHandler.handle(type, fieldValue0, fieldName, declaringClass, updateListener, reflectionFormBuilder);
            return retValue;
        }
        Type genericType = this.retrieveTypeGenericType(type);
        TypeHandler<?, ?, ?, ?> genericTypeHandler = this.genericsTypeHandlerMapping.get(genericType);
        if (genericTypeHandler != null) {
            return genericTypeHandler.handle(genericType, fieldValue0, fieldName, declaringClass, updateListener, reflectionFormBuilder);
        }
        return this.handleGenericType(genericType, fieldValue0, fieldName, declaringClass, updateListener, reflectionFormBuilder);
    }

    protected abstract Pair<JComponent, ComponentHandler<?>> handleGenericType(Type var1, List<Object> var2, String var3, Class<?> var4, FieldUpdateListener<FieldUpdateEvent<List<Object>>> var5, R var6) throws FieldHandlingException, ResetException;

    public Type retrieveTypeGenericType(Type type) {
        Object retValue;
        if (!(type instanceof ParameterizedType)) {
            return type;
        }
        ParameterizedType fieldTypeParameterized = (ParameterizedType)type;
        Type[] genericTypeArguments = fieldTypeParameterized.getActualTypeArguments();
        if (genericTypeArguments.length == 0) {
            retValue = Object.class;
        } else {
            if (genericTypeArguments.length > 1) {
                throw new IllegalArgumentException("more than 1 type argument not supported");
            }
            retValue = genericTypeArguments[0];
        }
        return retValue;
    }
}

