/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.storage;

import com.thoughtworks.xstream.XStream;
import de.richtercloud.reflection.form.builder.storage.StorageConf;
import de.richtercloud.reflection.form.builder.storage.StorageConfValidationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;

public class XMLStorageConf
implements StorageConf {
    private File file;

    protected XMLStorageConf() {
    }

    public XMLStorageConf(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void validate() throws StorageConfValidationException {
        XStream xStream = new XStream();
        try {
            xStream.fromXML(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new StorageConfValidationException(ex);
        }
    }

    @Override
    public String getShortDescription() {
        return "XML file storage";
    }

    @Override
    public String getLongDescription() {
        return "Stores data in an XML file (quite inefficient)";
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.file);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLStorageConf other = (XMLStorageConf)obj;
        return Objects.equals(this.file, other.file);
    }
}

