/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.storage;

import com.thoughtworks.xstream.XStream;
import de.richtercloud.reflection.form.builder.storage.AbstractStorage;
import de.richtercloud.reflection.form.builder.storage.Identifiable;
import de.richtercloud.reflection.form.builder.storage.Storage;
import de.richtercloud.reflection.form.builder.storage.StorageCallback;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.reflection.form.builder.storage.StorageException;
import de.richtercloud.reflection.form.builder.storage.XMLStorageConf;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;

public class XMLStorage<T extends Identifiable>
extends AbstractStorage<T, XMLStorageConf>
implements Storage<T, XMLStorageConf> {
    private static final String NOT_SUPPORTED = "Not supported yet.";
    private final File file;
    private final XMLStorageConf storageConf;

    public XMLStorage(XMLStorageConf storageConf) {
        this.file = storageConf.getFile();
        this.storageConf = storageConf;
    }

    @Override
    public void store(T object) throws StorageException {
        List existingObjects;
        XStream xStream = new XStream();
        try {
            existingObjects = (List)xStream.fromXML(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new StorageException(ex);
        }
        existingObjects.add(object);
        xStream = new XStream();
        try {
            xStream.toXML((Object)existingObjects, Files.newOutputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new StorageException(ex);
        }
    }

    @Override
    public <U extends T> U retrieve(Object id, Class<U> clazz) throws StorageException {
        List existingObjects;
        XStream xStream = new XStream();
        try {
            existingObjects = (List)xStream.fromXML(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new StorageException(ex);
        }
        for (Identifiable existingObject : existingObjects) {
            if (!existingObject.getId().equals(id)) continue;
            return (U)existingObject;
        }
        return null;
    }

    @Override
    public void update(T object) throws StorageException {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void delete(T object) throws StorageException {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void refresh(Object object) throws StorageException {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void start() throws StorageCreationException {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public XMLStorageConf getStorageConf() {
        return this.storageConf;
    }

    @Override
    public void registerPostStoreCallback(T object, StorageCallback callback) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public void registerPreStoreCallback(T object, StorageCallback callback) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }
}

