/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.storage;

import de.richtercloud.reflection.form.builder.storage.Storage;
import de.richtercloud.reflection.form.builder.storage.StorageConf;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.reflection.form.builder.storage.StorageFactory;
import de.richtercloud.reflection.form.builder.storage.XMLStorage;
import de.richtercloud.reflection.form.builder.storage.XMLStorageConf;
import de.richtercloud.reflection.form.builder.storage.XMLStorageFactory;

public class DelegatingStorageFactory
implements StorageFactory<Storage, StorageConf> {
    private final XMLStorageFactory xMLStorageFactory;

    public DelegatingStorageFactory() {
        this.xMLStorageFactory = new XMLStorageFactory();
    }

    public DelegatingStorageFactory(XMLStorageFactory xMLStorageFactory) {
        this.xMLStorageFactory = xMLStorageFactory;
    }

    @Override
    public Storage create(StorageConf storageConf) throws StorageCreationException {
        if (!(storageConf instanceof XMLStorageConf)) {
            throw new IllegalArgumentException(String.format("Storage configurations of type '%s' aren't supported by this storage factory", storageConf.getClass()));
        }
        XMLStorage retValue = this.xMLStorageFactory.create((XMLStorageConf)storageConf);
        return retValue;
    }
}

