/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.storage;

import de.richtercloud.reflection.form.builder.storage.Storage;
import de.richtercloud.reflection.form.builder.storage.StorageCallback;
import de.richtercloud.reflection.form.builder.storage.StorageConf;
import de.richtercloud.reflection.form.builder.storage.StorageCreationException;
import de.richtercloud.reflection.form.builder.storage.StorageException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractStorage<T, C extends StorageConf>
implements Storage<T, C> {
    private final Map<Object, List<StorageCallback>> postStoreCallbackMap = new HashMap<Object, List<StorageCallback>>();
    private final Map<Object, List<StorageCallback>> preStoreCallbackMap = new HashMap<Object, List<StorageCallback>>();
    private boolean started;

    @Override
    public void start() throws StorageCreationException {
        this.started = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void registerPostStoreCallback(T object, StorageCallback callback) throws StorageException {
        List<StorageCallback> callbackList = this.postStoreCallbackMap.get(object);
        if (callbackList == null) {
            callbackList = new LinkedList<StorageCallback>();
            this.postStoreCallbackMap.put(object, callbackList);
        }
        callbackList.add(callback);
    }

    protected List<StorageCallback> getPostStoreCallbacks(T object) {
        return this.postStoreCallbackMap.get(object);
    }

    @Override
    public void registerPreStoreCallback(T object, StorageCallback callback) throws StorageException {
        List<StorageCallback> callbackList = this.preStoreCallbackMap.get(object);
        if (callbackList == null) {
            callbackList = new LinkedList<StorageCallback>();
            this.preStoreCallbackMap.put(object, callbackList);
        }
        callbackList.add(callback);
    }

    protected List<StorageCallback> getPreStoreCallbacks(T object) {
        return this.preStoreCallbackMap.get(object);
    }
}

