/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.retriever;

import com.google.common.collect.MoreCollectors;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import de.richtercloud.reflection.form.builder.retriever.FieldEdge;
import de.richtercloud.reflection.form.builder.retriever.FieldGroup;
import de.richtercloud.reflection.form.builder.retriever.FieldGroups;
import de.richtercloud.reflection.form.builder.retriever.FieldOrderValidationException;
import de.richtercloud.reflection.form.builder.retriever.FieldPosition;
import de.richtercloud.reflection.form.builder.retriever.FieldVertex;
import de.richtercloud.validation.tools.CachedFieldRetriever;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedCachedFieldRetriever
extends CachedFieldRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderedCachedFieldRetriever.class);
    private final Map<Class<?>, List<Field>> fieldOrderMap;
    private final Set<Class<?>> entityClasses;

    public OrderedCachedFieldRetriever(Set<Class<?>> entityClasses) throws FieldOrderValidationException {
        this(new HashMap(), entityClasses, false);
    }

    public OrderedCachedFieldRetriever(Map<Class<?>, List<Field>> fieldOrderMap, Set<Class<?>> entityClasses) throws FieldOrderValidationException {
        this(fieldOrderMap, entityClasses, false);
    }

    public OrderedCachedFieldRetriever(Map<Class<?>, List<Field>> fieldOrderMap, Set<Class<?>> entityClasses, boolean visualizeDependencyGraphOnError) throws FieldOrderValidationException {
        if (fieldOrderMap == null) {
            throw new IllegalArgumentException("fieldOrderMap mustn't be null");
        }
        this.fieldOrderMap = fieldOrderMap;
        this.entityClasses = entityClasses;
        this.init(visualizeDependencyGraphOnError);
    }

    private void init(boolean visualizeDependencyGraphOnError) throws FieldOrderValidationException {
        HashMap fieldGroupNameClassMapping = new HashMap();
        for (Class<?> entityClass : this.entityClasses) {
            Object relevantField2;
            FieldPosition relevantFieldPosition;
            Map<FieldGroups, Class<?>> fieldGroupsClassMap = this.generateFieldGroupsClassMap(entityClass);
            for (FieldGroups fieldGroupsAnnotation : fieldGroupsClassMap.keySet()) {
                assert (fieldGroupsAnnotation != null) : "null keys shouldn't be returned by generateFieldGroupsClassMap";
                FieldGroup[] fieldGroups = fieldGroupsAnnotation.fieldGroups();
                assert (fieldGroups != null);
                HashSet<String> fieldGroupsFieldGroupNames = new HashSet<String>();
                for (Object object : fieldGroups) {
                    assert (object.name() != null);
                    if (object.name().isEmpty()) {
                        throw new FieldOrderValidationException(String.format("Class %s specifies a %s annotation with an empty name", fieldGroupsClassMap.get(fieldGroupsAnnotation).getName(), FieldGroup.class.getName()));
                    }
                    if (fieldGroupsFieldGroupNames.contains(object.name())) {
                        throw new FieldOrderValidationException(String.format("Class %s specifies a %s annotation which contains two %s annotations with the same name value '%s'", fieldGroupsClassMap.get(fieldGroupsAnnotation).getName(), FieldGroups.class.getName(), FieldGroup.class.getName(), object.name()));
                    }
                    fieldGroupsFieldGroupNames.add(object.name());
                    Class existingDeclarationClass = (Class)fieldGroupNameClassMapping.get(object.name());
                    Class<?> currentDeclarationClass = fieldGroupsClassMap.get(fieldGroupsAnnotation);
                    if (existingDeclarationClass != null && !existingDeclarationClass.equals(currentDeclarationClass)) {
                        throw new FieldOrderValidationException(String.format("Both the classes %s and %s declare a %s annotation with name %s", existingDeclarationClass.getName(), currentDeclarationClass.getName(), FieldGroup.class.getName(), object.name()));
                    }
                    fieldGroupNameClassMapping.put(object.name(), currentDeclarationClass);
                }
            }
            List relevantFields = super.retrieveRelevantFields(entityClass);
            Map<FieldGroup, Class<?>> fieldGroupClassMap = this.generateFieldGroupClassMap(entityClass);
            for (Field relevantField2 : relevantFields) {
                Set fieldGroupNames;
                relevantFieldPosition = relevantField2.getAnnotation(FieldPosition.class);
                if (relevantFieldPosition == null) continue;
                assert (relevantFieldPosition.fieldGroup() != null);
                if (relevantFieldPosition.fieldGroup().isEmpty() || (fieldGroupNames = fieldGroupClassMap.keySet().stream().map(fieldGroup -> fieldGroup.name()).collect(Collectors.toSet())).contains(relevantFieldPosition.fieldGroup())) continue;
                throw new FieldOrderValidationException(String.format("Field %s references the field group %s which doesn't exist in the inheritance hierarchy of the class", this.getFieldString(relevantField2), relevantFieldPosition.fieldGroup()));
            }
            for (Object relevantField2 : relevantFields) {
                relevantFieldPosition = ((Field)relevantField2).getAnnotation(FieldPosition.class);
                if (relevantFieldPosition == null || !relevantFieldPosition.fieldGroup().isEmpty() || relevantFieldPosition.afterFields().length != 0 || relevantFieldPosition.beforeFields().length != 0) continue;
                throw new FieldOrderValidationException(String.format("Field %s has a %s annotation which references no field group and has an empty list of afterFields and beforeFields", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
            }
            for (Object relevantField2 : relevantFields) {
                int n;
                relevantFieldPosition = ((Field)relevantField2).getAnnotation(FieldPosition.class);
                if (relevantFieldPosition == null) continue;
                String[] fieldGroupNames = relevantFieldPosition.afterFields();
                int n2 = fieldGroupNames.length;
                boolean bl = false;
                while (n < n2) {
                    String afterFieldName2 = fieldGroupNames[n];
                    List afterFieldCandidates = relevantFields.stream().filter(relevantField0 -> relevantField0.getName().equals(afterFieldName2)).collect(Collectors.toList());
                    if (afterFieldCandidates.isEmpty()) {
                        throw new FieldOrderValidationException(String.format("Field %s specifies a field in the afterFields value of its %s annotation which can't be accessed", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
                    }
                    if (afterFieldCandidates.size() > 1) {
                        throw new FieldOrderValidationException(String.format("Field %s specifies a field name in the afterFields value of its %s annoatation which occurs more than once in the inheritance hierarchy which is valid Java, but not supported by this class", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
                    }
                    ++n;
                }
                for (String beforeFieldName2 : relevantFieldPosition.beforeFields()) {
                    List beforeFieldCandidates = relevantFields.stream().filter(relevantField0 -> relevantField0.getName().equals(beforeFieldName2)).collect(Collectors.toList());
                    if (beforeFieldCandidates.isEmpty()) {
                        throw new FieldOrderValidationException(String.format("Field %s specifies a field in the beforeFields value of its %s annotation which can't be accessed", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
                    }
                    if (beforeFieldCandidates.size() <= 1) continue;
                    throw new FieldOrderValidationException(String.format("Field %s specifies a field name in the beforeFields value of its %s annoatation which occurs more than once in the inheritance hierarchy which is valid Java, but not supported by this class", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
                }
                if (Arrays.asList(relevantFieldPosition.afterFields()).contains(((Field)relevantField2).getName())) {
                    throw new FieldOrderValidationException(String.format("Field %s%s specifies the field itself in the afterFields value of its %s annotation", ((Field)relevantField2).getDeclaringClass().getName(), ((Field)relevantField2).getName(), FieldPosition.class.getName()));
                }
                if (!Arrays.asList(relevantFieldPosition.beforeFields()).contains(((Field)relevantField2).getName())) continue;
                throw new FieldOrderValidationException(String.format("Field %s specifies the field itself in the beforeFields value of its %s annotation", this.getFieldString((Field)relevantField2), FieldPosition.class.getName()));
            }
            Map<FieldGroup, List<Field>> fieldGroupFieldMap = this.generateFieldGroupFieldMap(relevantFields, fieldGroupClassMap);
            for (FieldGroup fieldGroup3 : fieldGroupFieldMap.keySet()) {
                List<Field> fieldGroupFields = fieldGroupFieldMap.get(fieldGroup3);
                for (Field field : fieldGroupFields) {
                    FieldPosition fieldGroupFieldPosition = field.getAnnotation(FieldPosition.class);
                    assert (fieldGroupFieldPosition != null);
                    Set fieldGroupFieldNames = fieldGroupFields.stream().map(fieldGroupField0 -> fieldGroupField0.getName()).collect(Collectors.toSet());
                    LOGGER.trace(String.format("fieldGroupFieldNames: %s", fieldGroupFieldNames));
                    if (fieldGroupFieldPosition.afterFields().length > 0 && Stream.of(fieldGroupFieldPosition.afterFields()).anyMatch(afterFieldName -> !fieldGroupFieldNames.contains(afterFieldName))) {
                        throw new FieldOrderValidationException(String.format("Field %s specifies fields in the afterFields value of its %s annoation which are not in the same field group '%s' specified on class %s", this.getFieldString(field), FieldPosition.class.getName(), fieldGroup3.name(), fieldGroupClassMap.get(fieldGroup3).getName()));
                    }
                    if (fieldGroupFieldPosition.beforeFields().length <= 0 || !Stream.of(fieldGroupFieldPosition.beforeFields()).anyMatch(beforeFieldName -> !fieldGroupFieldNames.contains(beforeFieldName))) continue;
                    throw new FieldOrderValidationException(String.format("Field %s specifies fields in the beforeFields value of its %s annoation which are not in the same field group '%s' specified on class %s", this.getFieldString(field), FieldPosition.class.getName(), fieldGroup3.name(), fieldGroupClassMap.get(fieldGroup3).getName()));
                }
            }
            relevantField2 = fieldGroupClassMap.keySet().iterator();
            while (relevantField2.hasNext()) {
                int n;
                FieldGroup fieldGroup2 = relevantField2.next();
                String[] fieldGroupFields = fieldGroup2.beforeGroups();
                int n3 = fieldGroupFields.length;
                boolean bl = false;
                while (n < n3) {
                    String beforeGroupName = fieldGroupFields[n];
                    try {
                        fieldGroupClassMap.keySet().stream().filter(fieldGroup0 -> fieldGroup0.name().equals(beforeGroupName)).collect(MoreCollectors.onlyElement());
                    }
                    catch (NoSuchElementException ex) {
                        throw new FieldOrderValidationException(String.format("Field group %s specified on class %s specifies field group %s in its beforeGroups value which doesn't exist in the inheritance hierarchy", fieldGroup2.name(), fieldGroupClassMap.get(fieldGroup2).getName(), beforeGroupName), ex);
                    }
                    ++n;
                }
                for (String afterGroupName : fieldGroup2.afterGroups()) {
                    try {
                        fieldGroupClassMap.keySet().stream().filter(fieldGroup0 -> fieldGroup0.name().equals(afterGroupName)).collect(MoreCollectors.onlyElement());
                    }
                    catch (NoSuchElementException ex) {
                        throw new FieldOrderValidationException(String.format("Field group %s specified on class %s specifies field group %s in its afterGroups value which doesn't exist in the inheritance hierarchy", fieldGroup2.name(), fieldGroupClassMap.get(fieldGroup2).getName(), afterGroupName), ex);
                    }
                }
            }
            DirectedGraph<Field, DefaultEdge> graph = this.generateGraph(relevantFields, fieldGroupFieldMap);
            CycleDetector cycleDetector = new CycleDetector(graph);
            Set cycles = cycleDetector.findCycles();
            if (cycles.isEmpty()) continue;
            if (visualizeDependencyGraphOnError) {
                this.visualizeGraph(graph, field0 -> new FieldVertex((Field)field0));
            }
            throw new FieldOrderValidationException(String.format("Class %s contains the following cyclic in its field order specification: %s (the complete graph was %s)", entityClass.getName(), cycles.toString(), graph.toString()));
        }
    }

    public List<Field> retrieveRelevantFields(Class<?> entityClass) {
        if (!this.entityClasses.contains(entityClass)) {
            throw new IllegalArgumentException(String.format("entityClass %s isn't contained in the set of managed entity classes", entityClass.getName()));
        }
        List<Field> retValue = this.fieldOrderMap.get(entityClass);
        if (retValue == null) {
            LinkedList<Field> relevantFields = new LinkedList<Field>(super.retrieveRelevantFields(entityClass));
            retValue = new LinkedList<Field>();
            Map<FieldGroup, Class<?>> fieldGroupClassMap = this.generateFieldGroupClassMap(entityClass);
            Map<FieldGroup, List<Field>> fieldGroupFieldMap = this.generateFieldGroupFieldMap(relevantFields, fieldGroupClassMap);
            for (FieldGroup fieldGroup : fieldGroupFieldMap.keySet()) {
                List<Field> fieldGroupFields = fieldGroupFieldMap.get(fieldGroup);
                assert (fieldGroupFields != null);
                fieldGroupFields.sort((field0, field1) -> {
                    assert (field0 != null);
                    assert (field1 != null);
                    if (field0.equals(field1)) {
                        int compareValue = 0;
                        LOGGER.trace(String.format("returning %d for %s and %s since they're equal", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1), this.getFieldString((Field)field1), this.getFieldString((Field)field0)));
                        return compareValue;
                    }
                    FieldPosition field0Position = field0.getAnnotation(FieldPosition.class);
                    FieldPosition field1Position = field1.getAnnotation(FieldPosition.class);
                    assert (field0Position != null);
                    assert (field1Position != null);
                    assert (!field0Position.fieldGroup().isEmpty());
                    assert (field0Position.fieldGroup().equals(field1Position.fieldGroup()));
                    if (Arrays.asList(field0Position.afterFields()).contains(field1.getName())) {
                        assert (!Arrays.asList(field1Position.afterFields()).contains(field0.getName()));
                        int compareValue = 1;
                        LOGGER.trace(String.format("returning %d for %s and %s since %s is an afterField of %s", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1), this.getFieldString((Field)field1), this.getFieldString((Field)field0)));
                        return compareValue;
                    }
                    if (Arrays.asList(field0Position.beforeFields()).contains(field1.getName())) {
                        assert (!Arrays.asList(field1Position.beforeFields()).contains(field0.getName()));
                        int compareValue = -1;
                        LOGGER.trace(String.format("returning %d for %s and %s since %s is a beforeField of %s", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1), this.getFieldString((Field)field1), this.getFieldString((Field)field0)));
                        return compareValue;
                    }
                    if (Arrays.asList(field1Position.afterFields()).contains(field0.getName())) {
                        assert (!Arrays.asList(field0Position.afterFields()).contains(field1.getName()));
                        int compareValue = -1;
                        LOGGER.trace(String.format("returning %d for %s and %s since %s is an afterField of %s", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1), this.getFieldString((Field)field0), this.getFieldString((Field)field1)));
                        return compareValue;
                    }
                    if (Arrays.asList(field1Position.beforeFields()).contains(field0.getName())) {
                        assert (!Arrays.asList(field0Position.beforeFields()).contains(field1.getName()));
                        int compareValue = 1;
                        LOGGER.trace(String.format("returning %d for %s and %s since %s is a beforeField of %s", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1), this.getFieldString((Field)field0), this.getFieldString((Field)field1)));
                        return compareValue;
                    }
                    int compareValue = Integer.compare(relevantFields.indexOf(field0), relevantFields.indexOf(field1));
                    LOGGER.trace(String.format("returning %d for %s and %s since both don't have relevant order annotation value", compareValue, this.getFieldString((Field)field0), this.getFieldString((Field)field1)));
                    return compareValue;
                });
            }
            DefaultDirectedGraph sortingGraph = new DefaultDirectedGraph(DefaultEdge.class);
            for (FieldGroup fieldGroup : fieldGroupClassMap.keySet()) {
                sortingGraph.addVertex((Object)fieldGroup);
            }
            for (FieldGroup fieldGroup : sortingGraph.vertexSet()) {
                for (String beforeGroupName : fieldGroup.beforeGroups()) {
                    List beforeFieldGroupCandidates = fieldGroupClassMap.keySet().stream().filter(fieldGroup0 -> fieldGroup0.name().equals(beforeGroupName)).collect(Collectors.toList());
                    FieldGroup beforeFieldGroup = (FieldGroup)beforeFieldGroupCandidates.stream().collect(MoreCollectors.onlyElement());
                    sortingGraph.addEdge((Object)fieldGroup, (Object)beforeFieldGroup);
                }
                for (String afterGroupName : fieldGroup.afterGroups()) {
                    FieldGroup afterFieldGroup = (FieldGroup)fieldGroupClassMap.keySet().stream().filter(fieldGroup0 -> fieldGroup0.name().equals(afterGroupName)).collect(MoreCollectors.onlyElement());
                    sortingGraph.addEdge((Object)afterFieldGroup, (Object)fieldGroup);
                }
            }
            TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator((DirectedGraph)sortingGraph);
            while (topologicalOrderIterator.hasNext()) {
                FieldGroup sortingGraphNxt = (FieldGroup)topologicalOrderIterator.next();
                List<Field> fieldGroupFields = fieldGroupFieldMap.get(sortingGraphNxt);
                if (fieldGroupFields == null) continue;
                retValue.addAll(fieldGroupFields);
            }
            for (Field relevantField : relevantFields) {
                if (retValue.contains(relevantField)) continue;
                retValue.add(relevantField);
            }
            this.fieldOrderMap.put(entityClass, retValue);
        }
        return retValue;
    }

    private Map<FieldGroup, Class<?>> generateFieldGroupClassMap(Class<?> entityClass) {
        HashMap fieldGroupMap = new HashMap();
        List inheritanceClasses = OrderedCachedFieldRetriever.generateInheritanceHierarchy(entityClass);
        for (Class inheritanceClass : inheritanceClasses) {
            FieldGroups fieldGroupsAnnotation = inheritanceClass.getAnnotation(FieldGroups.class);
            if (fieldGroupsAnnotation == null) continue;
            for (FieldGroup fieldGroup2 : fieldGroupsAnnotation.fieldGroups()) {
                fieldGroupMap.put(fieldGroup2, inheritanceClass);
            }
        }
        assert (fieldGroupMap.keySet().stream().map(fieldGroup -> fieldGroup.name()).collect(Collectors.toList()).size() == fieldGroupMap.keySet().stream().map(fieldGroup -> fieldGroup.name()).collect(Collectors.toSet()).size());
        return fieldGroupMap;
    }

    private Map<FieldGroup, List<Field>> generateFieldGroupFieldMap(List<Field> relevantFields, Map<FieldGroup, Class<?>> fieldGroupMap) {
        HashMap<FieldGroup, List<Field>> fieldGroupFieldMap = new HashMap<FieldGroup, List<Field>>();
        for (Field relevantField : relevantFields) {
            FieldPosition relevantFieldPosition = relevantField.getAnnotation(FieldPosition.class);
            if (relevantFieldPosition == null) continue;
            assert (relevantFieldPosition.fieldGroup() != null);
            if (relevantFieldPosition.fieldGroup().isEmpty()) continue;
            Set sameNameEntries = fieldGroupMap.entrySet().stream().filter(fieldGroupPair -> ((FieldGroup)fieldGroupPair.getKey()).name().equals(relevantFieldPosition.fieldGroup())).collect(Collectors.toSet());
            LOGGER.trace(String.format("sameNameEntries: %s", sameNameEntries));
            FieldGroup fieldGroup = (FieldGroup)((Map.Entry)sameNameEntries.stream().collect(MoreCollectors.onlyElement())).getKey();
            LinkedList<Field> fieldGroupFields = (LinkedList<Field>)fieldGroupFieldMap.get(fieldGroup);
            if (fieldGroupFields == null) {
                fieldGroupFields = new LinkedList<Field>();
                fieldGroupFieldMap.put(fieldGroup, fieldGroupFields);
            }
            fieldGroupFields.add(relevantField);
        }
        return fieldGroupFieldMap;
    }

    private DirectedGraph<Field, DefaultEdge> generateGraph(List<Field> relevantFields, Map<FieldGroup, List<Field>> fieldGroupFieldMap) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (Field relevantField : relevantFields) {
            graph.addVertex((Object)relevantField);
        }
        for (Field relevantField : relevantFields) {
            FieldPosition relevantFieldPosition = relevantField.getAnnotation(FieldPosition.class);
            if (relevantFieldPosition == null) continue;
            for (String beforeFieldName : relevantFieldPosition.beforeFields()) {
                FieldGroup beforeFieldGroup;
                Field beforeField = (Field)relevantFields.stream().filter(relevantField0 -> relevantField0.getName().equals(beforeFieldName)).collect(MoreCollectors.onlyElement());
                graph.addEdge((Object)relevantField, (Object)beforeField);
                FieldPosition beforeFieldPosition = beforeField.getAnnotation(FieldPosition.class);
                if (beforeFieldPosition == null || beforeFieldPosition.fieldGroup().isEmpty() || (beforeFieldGroup = (FieldGroup)fieldGroupFieldMap.keySet().stream().filter(fieldGroup -> fieldGroup.name().equals(beforeFieldPosition.fieldGroup())).collect(MoreCollectors.onlyElement())).name().equals(relevantFieldPosition.fieldGroup())) continue;
                List<Field> beforeFieldGroupFields = fieldGroupFieldMap.get(beforeFieldGroup);
                assert (beforeFieldGroupFields != null);
                for (Field beforeFieldGroupField : beforeFieldGroupFields) {
                    graph.addEdge((Object)relevantField, (Object)beforeFieldGroupField);
                }
            }
            for (String afterFieldName : relevantFieldPosition.afterFields()) {
                FieldGroup afterFieldGroup;
                Field afterField = (Field)relevantFields.stream().filter(relevantField0 -> relevantField0.getName().equals(afterFieldName)).collect(MoreCollectors.onlyElement());
                graph.addEdge((Object)afterField, (Object)relevantField);
                FieldPosition afterFieldPosition = afterField.getAnnotation(FieldPosition.class);
                if (afterFieldPosition == null || afterFieldPosition.fieldGroup().isEmpty() || (afterFieldGroup = (FieldGroup)fieldGroupFieldMap.keySet().stream().filter(fieldGroup -> fieldGroup.name().equals(afterFieldPosition.fieldGroup())).collect(MoreCollectors.onlyElement())).name().equals(relevantFieldPosition.fieldGroup())) continue;
                List<Field> afterFieldGroupFields = fieldGroupFieldMap.get(afterFieldGroup);
                assert (afterFieldGroupFields != null);
                for (Field afterFieldGroupField : afterFieldGroupFields) {
                    graph.addEdge((Object)afterFieldGroupField, (Object)relevantField);
                }
            }
        }
        for (FieldGroup fieldGroup2 : fieldGroupFieldMap.keySet()) {
            List sameNameEntries;
            List<Field> fieldGroupFields = fieldGroupFieldMap.get(fieldGroup2);
            for (String beforeFieldGroupName : fieldGroup2.beforeGroups()) {
                sameNameEntries = fieldGroupFieldMap.entrySet().stream().filter(entry -> ((FieldGroup)entry.getKey()).name().equals(beforeFieldGroupName)).collect(Collectors.toList());
                LOGGER.trace(String.format("sameNameEntries: %s", sameNameEntries));
                if (sameNameEntries.isEmpty()) continue;
                List beforeFieldGroupFields = (List)((Map.Entry)sameNameEntries.stream().collect(MoreCollectors.onlyElement())).getValue();
                for (Field beforeFieldGroupField : beforeFieldGroupFields) {
                    for (Field fieldGroupField : fieldGroupFields) {
                        graph.addEdge((Object)beforeFieldGroupField, (Object)fieldGroupField);
                    }
                }
            }
            for (String afterFieldGroupName : fieldGroup2.afterGroups()) {
                sameNameEntries = fieldGroupFieldMap.entrySet().stream().filter(entry -> ((FieldGroup)entry.getKey()).name().equals(afterFieldGroupName)).collect(Collectors.toList());
                LOGGER.trace(String.format("sameNameEntries: %s", sameNameEntries));
                if (sameNameEntries.isEmpty()) continue;
                List afterFieldGroupFields = (List)((Map.Entry)sameNameEntries.stream().collect(MoreCollectors.onlyElement())).getValue();
                for (Field afterFieldGroupField : afterFieldGroupFields) {
                    for (Field fieldGroupField : fieldGroupFields) {
                        graph.addEdge((Object)fieldGroupField, (Object)afterFieldGroupField);
                    }
                }
            }
        }
        return graph;
    }

    private Map<FieldGroups, Class<?>> generateFieldGroupsClassMap(Class<?> entityClass) {
        HashMap retValue = new HashMap();
        List hierarchyClasses = OrderedCachedFieldRetriever.generateInheritanceHierarchy(entityClass);
        for (Class hierarchyClass : hierarchyClasses) {
            FieldGroups hierarchyClassFieldGroups = hierarchyClass.getAnnotation(FieldGroups.class);
            if (hierarchyClassFieldGroups == null) continue;
            retValue.put(hierarchyClassFieldGroups, hierarchyClass);
        }
        return retValue;
    }

    private <O, I> void visualizeGraph(DirectedGraph<I, DefaultEdge> graph, VisualizationVertexFactory<O, I> visualizationEdgeFactory) {
        try {
            Runnable runnable = () -> {
                JDialog dialog = new JDialog((Frame)null, "Failure: The field order dependency graph contains cycles!", true);
                dialog.setDefaultCloseOperation(2);
                DefaultDirectedGraph graph0 = new DefaultDirectedGraph(FieldEdge.class);
                for (Object vertex : graph.vertexSet()) {
                    Object transformedVertex = visualizationEdgeFactory.create(vertex);
                    graph0.addVertex(transformedVertex);
                }
                for (DefaultEdge edge : graph.edgeSet()) {
                    Object transformedSource = visualizationEdgeFactory.create(graph.getEdgeSource((Object)edge));
                    Object transformedTarget = visualizationEdgeFactory.create(graph.getEdgeTarget((Object)edge));
                    graph0.addEdge(transformedSource, transformedTarget);
                }
                JGraphXAdapter graphAdapter = new JGraphXAdapter((Graph)graph0);
                mxCircleLayout layout = new mxCircleLayout((mxGraph)graphAdapter);
                layout.execute(graphAdapter.getDefaultParent());
                dialog.add((Component)new mxGraphComponent((mxGraph)graphAdapter));
                dialog.pack();
                dialog.setLocationByPlatform(true);
                LOGGER.info("displayed field order dependency graph visualization dialog and waiting for it to be closed before continueing");
                dialog.setVisible(true);
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (HeadlessException ex) {
            LOGGER.warn("experienced headless exception during visualization of field and field group dependency order graph, so naively assuming a headless environment and skipping this silently", (Throwable)ex);
        }
    }

    private String getFieldString(Field field) {
        return String.format("%s.%s", field.getDeclaringClass().getName(), field.getName());
    }

    @FunctionalInterface
    private static interface VisualizationVertexFactory<O, I> {
        public O create(I var1);
    }
}

