/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.panels;

import de.richtercloud.reflection.form.builder.panels.ListPanelTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class SingleColumnListPanelTableModel<T>
extends DefaultTableModel
implements ListPanelTableModel<T> {
    private static final long serialVersionUID = 1L;
    private final List<T> values = new ArrayList<T>();
    private final Class<? extends T> columnClass;

    public SingleColumnListPanelTableModel(Class<? extends T> columnClass) {
        this.columnClass = columnClass;
    }

    @Override
    public List<T> getData() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public void addColumn(String columnName) {
        super.addColumn(columnName);
    }

    @Override
    public void removeElement(int row) {
        this.values.remove(row);
        this.fireTableDataChanged();
    }

    @Override
    public void addElement(T element) {
        this.values.add(element);
        this.fireTableDataChanged();
    }

    @Override
    public void insertElementAt(int row, T element) {
        this.values.add(row, element);
        this.fireTableDataChanged();
    }

    @Override
    public void removeElement(T element) {
        this.values.remove(element);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= this.values.size()) {
            this.values.add(aValue);
        } else {
            this.values.set(rowIndex, aValue);
        }
    }
}

