/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.panels;

import de.richtercloud.reflection.form.builder.panels.NumberPanelUpdateEvent;
import de.richtercloud.reflection.form.builder.panels.NumberPanelUpdateListener;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public abstract class NumberPanel<N extends Number>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SpinnerNumberModel idSpinnerModel = new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L);
    private final Set<NumberPanelUpdateListener<N>> updateListeners = new HashSet<NumberPanelUpdateListener<N>>();
    private GroupLayout.Group layoutHorizontalGroup;
    private GroupLayout.Group layoutVerticalGroup;
    private JSpinner valueSpinner;
    private JCheckBox nullCheckBox;
    private final Number initialValue;

    public NumberPanel(N initialValue, boolean readOnly) {
        this.initComponents();
        this.valueSpinner.addChangeListener(e -> {
            for (NumberPanelUpdateListener<N> updateListener : this.updateListeners) {
                updateListener.onUpdate(new NumberPanelUpdateEvent<N>(this.getValue()));
            }
        });
        this.nullCheckBox.addActionListener(e -> {
            for (NumberPanelUpdateListener<N> updateListener : this.updateListeners) {
                updateListener.onUpdate(new NumberPanelUpdateEvent<N>(this.getValue()));
            }
        });
        this.initialValue = initialValue;
        if (readOnly) {
            this.valueSpinner.setEnabled(false);
        }
        this.reset0();
    }

    public void addUpdateListener(NumberPanelUpdateListener<N> updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(NumberPanelUpdateListener<N> updateListener) {
        this.updateListeners.remove(updateListener);
    }

    public Set<NumberPanelUpdateListener<N>> getUpdateListeners() {
        return Collections.unmodifiableSet(this.updateListeners);
    }

    public N getValue() {
        return (N)((Number)(this.nullCheckBox.isSelected() ? null : this.valueSpinner.getValue()));
    }

    public void setValue(N value) {
        if (value == null) {
            this.nullCheckBox.setSelected(true);
            this.valueSpinner.setEnabled(false);
        } else {
            this.nullCheckBox.setSelected(false);
            this.valueSpinner.setEnabled(true);
            this.valueSpinner.setValue(value);
        }
    }

    private void initComponents() {
        this.valueSpinner = new JSpinner();
        this.nullCheckBox = new JCheckBox();
        this.valueSpinner.setModel(this.idSpinnerModel);
        this.nullCheckBox.setText("null");
        this.nullCheckBox.addActionListener(evt -> this.nullCheckBoxActionPerformed(evt));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.layoutHorizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        this.layoutVerticalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        layout.setHorizontalGroup(this.layoutHorizontalGroup.addGroup(layout.createSequentialGroup().addComponent(this.nullCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.valueSpinner, 0, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(this.layoutVerticalGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueSpinner, -2, -1, -2).addComponent(this.nullCheckBox)));
    }

    protected GroupLayout.Group getLayoutHorizontalGroup() {
        return this.layoutHorizontalGroup;
    }

    protected GroupLayout.Group getLayoutVerticalGroup() {
        return this.layoutVerticalGroup;
    }

    @Override
    public GroupLayout getLayout() {
        return (GroupLayout)super.getLayout();
    }

    private void nullCheckBoxActionPerformed(ActionEvent evt) {
        if (this.nullCheckBox.isSelected()) {
            this.valueSpinner.setEnabled(false);
        } else {
            this.valueSpinner.setEnabled(true);
        }
        for (NumberPanelUpdateListener<N> updateListener : this.updateListeners) {
            updateListener.onUpdate(new NumberPanelUpdateEvent<N>(this.getValue()));
        }
    }

    public void reset() {
        this.reset0();
    }

    private void reset0() {
        if (this.initialValue == null) {
            this.nullCheckBox.setSelected(true);
            this.valueSpinner.setEnabled(false);
        } else {
            this.valueSpinner.setValue(this.initialValue);
            this.nullCheckBox.setSelected(false);
        }
    }
}

