/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.panels;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilderUtils;
import de.richtercloud.reflection.form.builder.panels.CancelablePanelPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class CancelablePanel<P extends CancelablePanelPanel, T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CANCEL_PANEL_CONSTRAINT = "cancel-panel";
    private static final String MAIN_PANEL_CONSTRAINT = "main-panel";
    private final P mainPanel;
    private final Box.Filler filler1;
    private final Box.Filler filler2;
    private final JButton cancelButton;
    private final JPanel cancelPanel;
    private final LayoutManager layout = new CardLayout();

    public CancelablePanel(P mainPanel) {
        this.mainPanel = mainPanel;
        ((CancelablePanelPanel)mainPanel).addCancelablePanelListener((async, cancelable) -> this.doTask(async, cancelable));
        this.setLayout(this.layout);
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(event -> this.cancelTask());
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.cancelPanel = new JPanel();
        this.cancelPanel.setLayout(new BoxLayout(this.cancelPanel, 2));
        this.cancelPanel.add(this.filler1);
        this.cancelPanel.add(this.cancelButton);
        this.cancelPanel.add(this.filler2);
        this.add((Component)this.cancelPanel, CANCEL_PANEL_CONSTRAINT);
        this.add((Component)mainPanel, MAIN_PANEL_CONSTRAINT);
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, MAIN_PANEL_CONSTRAINT);
    }

    public P getMainPanel() {
        return this.mainPanel;
    }

    public void doTask(boolean async, boolean cancelable) {
        ReflectionFormBuilderUtils.disableRecursively(this.mainPanel, false);
        if (cancelable) {
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show(this, CANCEL_PANEL_CONSTRAINT);
        }
        if (!async) {
            T nonGUIResult = this.doTaskNonGUI();
            if (nonGUIResult == null) {
                return;
            }
            this.doTaskGUI0(nonGUIResult);
        } else {
            Thread backgroundThread = new Thread(() -> {
                T nonGUIResult = this.doTaskNonGUI();
                if (nonGUIResult == null) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.doTaskGUI0(nonGUIResult));
            }, "ocr-fetch-thread");
            backgroundThread.start();
        }
    }

    protected abstract T doTaskNonGUI();

    private void doTaskGUI0(T nonGUIResult) {
        ReflectionFormBuilderUtils.disableRecursively(this.mainPanel, true);
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, MAIN_PANEL_CONSTRAINT);
        this.doTaskGUI(nonGUIResult);
    }

    protected abstract void doTaskGUI(T var1);

    protected abstract void cancelTask();
}

