/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.panels;

import de.richtercloud.message.handler.Message;
import de.richtercloud.message.handler.MessageHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.TransformationException;
import de.richtercloud.reflection.form.builder.panels.ListPanelItemEvent;
import de.richtercloud.reflection.form.builder.panels.ListPanelItemEventVetoException;
import de.richtercloud.reflection.form.builder.panels.ListPanelItemListener;
import de.richtercloud.reflection.form.builder.panels.ListPanelTableCellEditor;
import de.richtercloud.reflection.form.builder.panels.ListPanelTableCellRenderer;
import de.richtercloud.reflection.form.builder.panels.ListPanelTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListPanel<T, L extends ListPanelItemListener<T>, M extends ListPanelTableModel<T>, R extends ReflectionFormBuilder>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractListPanel.class);
    private final R reflectionFormBuilder;
    public static final Comparator<Integer> DESCENDING_ORDER = (o1, o2) -> o2.compareTo((Integer)o1);
    private final ListSelectionModel mainListSelectionModel = new DefaultListSelectionModel();
    private final Set<L> itemListeners = new HashSet<L>();
    private final ListPanelTableCellEditor mainListCellEditor;
    private final M mainListModel;
    private final MessageHandler messageHandler;
    private final List<T> initialValues;
    private JButton addButton;
    private JButton downButton;
    private JButton editButton;
    private JButton invertSelectionButton;
    private JTable mainList;
    private JScrollPane mainListScrollPane;
    private JButton removeButton;
    private JButton selectAllButton;
    private JButton upButton;

    public AbstractListPanel(R reflectionFormBuilder, ListPanelTableCellEditor mainListCellEditor, ListPanelTableCellRenderer mainListCellRenderer, M mainListModel, List<T> initialValues, MessageHandler messageHandler, JTableHeader tableHeader) {
        this.reflectionFormBuilder = reflectionFormBuilder;
        this.mainListCellEditor = mainListCellEditor;
        this.mainListModel = mainListModel;
        this.initComponents();
        this.mainList.setTableHeader(tableHeader);
        this.mainList.setColumnModel(tableHeader.getColumnModel());
        this.mainList.setDefaultRenderer(Object.class, mainListCellRenderer);
        this.mainList.setDefaultEditor(Object.class, mainListCellEditor);
        this.messageHandler = messageHandler;
        this.initialValues = initialValues;
    }

    public void addValue(T value) throws TransformationException, NoSuchFieldException, ResetException {
        this.getMainListModel().addElement(value);
        for (ListPanelItemListener listener : this.getItemListeners()) {
            try {
                listener.onItemAdded(new ListPanelItemEvent(1, this.getMainListModel().getRowCount(), this.getMainListModel().getData()));
            }
            catch (ListPanelItemEventVetoException ex) {
                this.messageHandler.handle(new Message((Throwable)ex, 0));
                return;
            }
        }
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
        this.getMainList().getSelectionModel().setSelectionInterval(this.getMainListModel().getRowCount() - 1, this.getMainListModel().getRowCount() - 1);
        this.editRow0();
    }

    public void addItemListener(L itemListener) {
        this.itemListeners.add(itemListener);
    }

    public void removeItemListener(L itemListener) {
        this.itemListeners.remove(itemListener);
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.selectAllButton = new JButton();
        this.invertSelectionButton = new JButton();
        this.mainListScrollPane = new JScrollPane();
        this.mainList = new JTable();
        this.editButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.selectAllButton.setText("Select all");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.invertSelectionButton.setText("Invert selection");
        this.invertSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.invertSelectionButtonActionPerformed(evt);
            }
        });
        this.mainList.setModel((TableModel)this.mainListModel);
        this.mainList.setCellEditor(this.mainListCellEditor);
        this.mainList.setSelectionModel(this.mainListSelectionModel);
        this.mainListScrollPane.setViewportView(this.mainList);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.editButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("Up");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText("Down");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractListPanel.this.downButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainListScrollPane, -1, 286, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.invertSelectionButton, GroupLayout.Alignment.TRAILING, -1, 165, Short.MAX_VALUE).addComponent(this.selectAllButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainListScrollPane, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.invertSelectionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.mainListCellEditor.stopCellEditing();
        this.mainListCellEditor.resetCellEditorValue();
        T newElement = this.createNewElement();
        try {
            this.addValue(newElement);
        }
        catch (ResetException | TransformationException | NoSuchFieldException ex) {
            this.messageHandler.handle(new Message((Throwable)ex, 0));
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        LOGGER.debug("removing selected rows {}", (Object)this.mainList.getSelectedRows());
        if (this.mainList.getSelectedRowCount() == 0) {
            return;
        }
        this.mainListCellEditor.stopCellEditing();
        LinkedList<Integer> selectedRowsSorted = new LinkedList<Integer>();
        for (int selectedRow : this.mainList.getSelectedRows()) {
            selectedRowsSorted.add(selectedRow);
        }
        Collections.sort(selectedRowsSorted, DESCENDING_ORDER);
        Object object = selectedRowsSorted.iterator();
        while (object.hasNext()) {
            int selectedRow = (Integer)object.next();
            this.mainListModel.removeElement(selectedRow);
            for (ListPanelItemListener itemListener : this.getItemListeners()) {
                try {
                    itemListener.onItemRemoved(new ListPanelItemEvent(2, selectedRow, this.mainListModel.getData()));
                }
                catch (ListPanelItemEventVetoException ex) {
                    this.messageHandler.handle(new Message((Throwable)ex, 0));
                    return;
                }
            }
        }
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        this.mainListSelectionModel.addSelectionInterval(0, this.mainList.getRowCount() - 1);
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void invertSelectionButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.mainListModel.getRowCount(); ++i) {
            if (this.mainListSelectionModel.isSelectedIndex(i)) {
                this.mainListSelectionModel.removeIndexInterval(i, i);
                continue;
            }
            this.mainListSelectionModel.addSelectionInterval(i, i);
        }
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        try {
            this.editRow0();
        }
        catch (ResetException | TransformationException | NoSuchFieldException ex) {
            this.messageHandler.handle(new Message(String.format("An exception during editing the row occured: %s", ExceptionUtils.getRootCauseMessage((Throwable)ex)), 0, "Exception occured"));
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.mainListCellEditor.stopCellEditing();
        for (int selectedRow : this.mainList.getSelectedRows()) {
            if (selectedRow == 0) continue;
            Object toRemove = this.mainListModel.getData().get(selectedRow);
            LOGGER.debug(String.format("moving item %s from %d to %d", toRemove, selectedRow, selectedRow - 1));
            this.mainListModel.removeElement(selectedRow);
            this.mainListModel.insertElementAt(selectedRow - 1, toRemove);
        }
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.mainListCellEditor.stopCellEditing();
        for (int selectedRow : this.mainList.getSelectedRows()) {
            if (selectedRow == this.mainList.getRowCount() - 1) continue;
            Object toRemove = this.mainListModel.getData().get(selectedRow);
            LOGGER.debug(String.format("moving item %s from %d to %d", toRemove, selectedRow, selectedRow + 1));
            this.mainListModel.removeElement(selectedRow);
            this.mainListModel.insertElementAt(selectedRow + 1, toRemove);
        }
        this.mainListModel.fireTableDataChanged();
        this.updateRowHeights();
    }

    private void editRow0() throws TransformationException, NoSuchFieldException, ResetException {
        this.editRow();
    }

    protected abstract void editRow() throws TransformationException, NoSuchFieldException, ResetException;

    protected void updateRowHeights() {
        for (int row = 0; row < this.mainList.getRowCount(); ++row) {
            int rowHeight = this.mainList.getRowHeight();
            for (int column = 0; column < this.mainList.getColumnCount(); ++column) {
                Component comp = this.mainList.prepareRenderer(this.mainList.getCellRenderer(row, column), row, column);
                rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            }
            this.mainList.setRowHeight(row, rowHeight);
        }
    }

    protected abstract T createNewElement();

    public R getReflectionFormBuilder() {
        return this.reflectionFormBuilder;
    }

    public M getMainListModel() {
        return this.mainListModel;
    }

    public Set<L> getItemListeners() {
        return this.itemListeners;
    }

    public JTable getMainList() {
        return this.mainList;
    }

    public ListPanelTableCellEditor getMainListCellEditor() {
        return this.mainListCellEditor;
    }

    public final void reset() {
        while (this.getMainListModel().getRowCount() > 0) {
            this.getMainListModel().removeElement(0);
        }
        if (this.initialValues != null) {
            for (T initialValue : this.initialValues) {
                this.getMainListModel().setValueAt(initialValue, this.getMainListModel().getRowCount(), 0);
            }
        }
    }
}

