/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler.factory;

import com.google.common.reflect.TypeToken;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.reflection.form.builder.AnyType;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.BooleanFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.BooleanListFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.BooleanPrimitiveFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.DateFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.DoubleFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.DoublePrimitiveFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FloatFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FloatPrimitiveFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.IntegerFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.IntegerListFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.IntegerPrimitiveFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.LongFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.LongPrimitiveFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.NumberFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.SimpleEntityListFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.SqlDateFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.StringFieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.StringListFieldHandler;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.sql.Date;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JSpinner;

public class MappingFieldHandlerFactory {
    private static final Map<Class<?>, FieldHandler<?, ?, ?, ?>> PRIMITIVE_MAPPING_DEFAULT;
    private final IssueHandler issueHandler;

    public static Type createStringTypeToken() {
        return new TypeToken<String>(){}.getType();
    }

    public static Type createFloatTypeToken() {
        return new TypeToken<Float>(){}.getType();
    }

    public static Type createIntegerTypetoken() {
        return new TypeToken<Integer>(){}.getType();
    }

    public static Type createDoubleTypeToken() {
        return new TypeToken<Double>(){}.getType();
    }

    public static Type createLongTypeToken() {
        return new TypeToken<Long>(){}.getType();
    }

    public static Type createNumberTypeToken() {
        return new TypeToken<Number>(){}.getType();
    }

    public static Type createBooleanTypeToken() {
        return new TypeToken<Boolean>(){}.getType();
    }

    public static Type createDateTypeToken() {
        return new TypeToken<java.util.Date>(){}.getType();
    }

    public static Type createSqlDateTypeToken() {
        return new TypeToken<Date>(){}.getType();
    }

    public static Type createBooleanListTypeToken() {
        return new TypeToken<List<Boolean>>(){}.getType();
    }

    public static Type createIntegerListTypeToken() {
        return new TypeToken<List<Integer>>(){}.getType();
    }

    public static Type createAnyTypeListTypeToken() {
        return new TypeToken<List<AnyType>>(){}.getType();
    }

    public static Type createStringListTypeToken() {
        return new TypeToken<List<String>>(){}.getType();
    }

    public MappingFieldHandlerFactory(IssueHandler issueHandler) {
        if (issueHandler == null) {
            throw new IllegalArgumentException("messageHandler mustn't be null");
        }
        this.issueHandler = issueHandler;
    }

    public IssueHandler getIssueHandler() {
        return this.issueHandler;
    }

    public Map<Type, FieldHandler<?, ?, ?, ?>> generateClassMapping() {
        HashMap classMapping0 = new HashMap();
        classMapping0.put(MappingFieldHandlerFactory.createStringTypeToken(), StringFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createFloatTypeToken(), FloatFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createIntegerTypetoken(), IntegerFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createDoubleTypeToken(), DoubleFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createLongTypeToken(), LongFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createNumberTypeToken(), NumberFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createBooleanTypeToken(), BooleanFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createDateTypeToken(), DateFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createSqlDateTypeToken(), SqlDateFieldHandler.getInstance());
        classMapping0.put(MappingFieldHandlerFactory.createBooleanListTypeToken(), new BooleanListFieldHandler(this.issueHandler));
        classMapping0.put(MappingFieldHandlerFactory.createIntegerListTypeToken(), new IntegerListFieldHandler(this.issueHandler));
        classMapping0.put(MappingFieldHandlerFactory.createAnyTypeListTypeToken(), new SimpleEntityListFieldHandler(this.issueHandler));
        classMapping0.put(MappingFieldHandlerFactory.createStringListTypeToken(), new StringListFieldHandler(this.issueHandler));
        return classMapping0;
    }

    public Map<Class<?>, FieldHandler<?, ?, ?, ?>> generatePrimitiveMapping() {
        HashMap primitiveMapping0 = new HashMap();
        primitiveMapping0.putAll(PRIMITIVE_MAPPING_DEFAULT);
        return Collections.unmodifiableMap(primitiveMapping0);
    }

    static {
        HashMap<Class<Serializable>, FieldHandler<Float, FieldUpdateEvent<Float>, ReflectionFormBuilder, JSpinner>> primitiveMappingDefault0 = new HashMap<Class<Serializable>, FieldHandler<Float, FieldUpdateEvent<Float>, ReflectionFormBuilder, JSpinner>>();
        primitiveMappingDefault0.put(Float.TYPE, FloatPrimitiveFieldHandler.getInstance());
        primitiveMappingDefault0.put(Integer.TYPE, IntegerPrimitiveFieldHandler.getInstance());
        primitiveMappingDefault0.put(Double.TYPE, DoublePrimitiveFieldHandler.getInstance());
        primitiveMappingDefault0.put(Long.TYPE, LongPrimitiveFieldHandler.getInstance());
        primitiveMappingDefault0.put(Boolean.TYPE, BooleanPrimitiveFieldHandler.getInstance());
        PRIMITIVE_MAPPING_DEFAULT = Collections.unmodifiableMap(primitiveMappingDefault0);
    }
}

