/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.StringTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class StringFieldHandler
implements FieldHandler<String, FieldUpdateEvent<String>, ReflectionFormBuilder, JTextField> {
    private static final StringFieldHandler INSTANCE = new StringFieldHandler();
    private final StringTypeHandler stringTypeHandler;

    public static StringFieldHandler getInstance() {
        return INSTANCE;
    }

    protected StringFieldHandler() {
        this(StringTypeHandler.getInstance());
    }

    public StringFieldHandler(StringTypeHandler stringTypeHandler) {
        this.stringTypeHandler = stringTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<String>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        String fieldValue;
        try {
            fieldValue = (String)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.stringTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(JTextField component) {
        component.setText("");
    }
}

