/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.components.date.SqlDatePicker;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.typehandler.SqlDateTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Date;
import javax.swing.JComponent;

public class SqlDateFieldHandler
implements FieldHandler<Date, FieldUpdateEvent<Date>, ReflectionFormBuilder, SqlDatePicker> {
    private static final SqlDateFieldHandler INSTANCE = new SqlDateFieldHandler();
    private final SqlDateTypeHandler sqlDateTypeHandler;

    public static SqlDateFieldHandler getInstance() {
        return INSTANCE;
    }

    protected SqlDateFieldHandler() {
        this(SqlDateTypeHandler.getInstance());
    }

    public SqlDateFieldHandler(SqlDateTypeHandler sqlDateTypeHandler) {
        this.sqlDateTypeHandler = sqlDateTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Date>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Date fieldValue;
        try {
            fieldValue = (Date)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.sqlDateTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(SqlDatePicker component) {
        component.reset();
    }
}

