/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ResettableFieldHandler<T, E extends FieldUpdateEvent<T>, R extends ReflectionFormBuilder, C extends Component>
implements FieldHandler<T, E, R, C> {
    private static final ComponentHandler<JLabel> JLABEL_COMPONENT_RESETTABLE = component -> component.setText("");
    private final Map<JComponent, ComponentHandler<?>> componentMapping = new HashMap();

    @Override
    public final JComponent handle(Field field, Object instance, FieldUpdateListener<E> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        Pair<JComponent, ComponentHandler<?>> retValueEntry = this.handle0(field, instance, updateListener, reflectionFormBuilder);
        if (retValueEntry == null) {
            JComponent retValue = this.retrieveDefaultComponent(field);
            this.componentMapping.put(retValue, JLABEL_COMPONENT_RESETTABLE);
            return retValue;
        }
        ComponentHandler componentResettable = (ComponentHandler)retValueEntry.getValue();
        if (componentResettable == null) {
            throw new IllegalArgumentException("ComponentResettable in Pair returned by handle0 mustn't be null");
        }
        JComponent retValue = (JComponent)retValueEntry.getKey();
        this.componentMapping.put(retValue, componentResettable);
        return retValue;
    }

    public JComponent retrieveDefaultComponent(Field field) {
        return new JLabel(field.getType().getSimpleName());
    }

    protected abstract Pair<JComponent, ComponentHandler<?>> handle0(Field var1, Object var2, FieldUpdateListener<E> var3, R var4) throws FieldHandlingException, ResetException;

    @Override
    public void reset(C component) throws ResetException {
        ComponentHandler<?> classPartHandler = this.componentMapping.get(component);
        if (classPartHandler == null) {
            throw new IllegalArgumentException(String.format("component '%s' doesn't have a %s mapped in componentMapping", component, ComponentHandler.class));
        }
        classPartHandler.reset(component);
    }
}

