/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.fieldhandler.ResettableFieldHandler;
import de.richtercloud.reflection.form.builder.panels.NumberPanel;
import de.richtercloud.reflection.form.builder.typehandler.NumberTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;

public class NumberFieldHandler
extends ResettableFieldHandler<Number, FieldUpdateEvent<Number>, ReflectionFormBuilder, NumberPanel> {
    private static final NumberFieldHandler INSTANCE = new NumberFieldHandler();
    private final NumberTypeHandler numberTypeHandler;

    public static NumberFieldHandler getInstance() {
        return INSTANCE;
    }

    protected NumberFieldHandler() {
        this(NumberTypeHandler.getInstance());
    }

    public NumberFieldHandler(NumberTypeHandler numberTypeHandler) {
        this.numberTypeHandler = numberTypeHandler;
    }

    @Override
    public Pair<JComponent, ComponentHandler<?>> handle0(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Number>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Number fieldValue;
        try {
            fieldValue = (Number)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return this.numberTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder);
    }

    @Override
    public void reset(NumberPanel component) {
        component.reset();
    }
}

