/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.message.handler.ExceptionMessage;
import de.richtercloud.message.handler.IssueHandler;
import de.richtercloud.reflection.form.builder.AnyType;
import de.richtercloud.reflection.form.builder.ComponentHandler;
import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.ResetException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.fieldhandler.ResettableFieldHandler;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFieldHandler<T, E extends FieldUpdateEvent<T>, R extends ReflectionFormBuilder, C extends Component>
extends ResettableFieldHandler<T, E, R, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingFieldHandler.class);
    private final Map<Type, FieldHandler<?, ?, ?, ?>> classMapping = new HashMap();
    private final Map<Class<?>, FieldHandler<?, ?, ?, ?>> primitiveMapping;
    private final IssueHandler issueHandler;

    protected static <K, V> void validateMapping(List<Pair<K, V>> mapping, String argumentName) {
        if (argumentName == null) {
            throw new IllegalArgumentException("argumentName mustn't be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("%s mustn't be null", argumentName));
        }
        if (mapping.contains(null)) {
            throw new IllegalArgumentException(String.format("%s mustn't contain null values", argumentName));
        }
    }

    public MappingFieldHandler(Map<Type, FieldHandler<?, ?, ?, ?>> classMapping, Map<Class<?>, FieldHandler<?, ?, ?, ?>> primitiveMapping, IssueHandler issueHandler) {
        if (issueHandler == null) {
            throw new IllegalArgumentException("issueHandler mustn't be null");
        }
        this.issueHandler = issueHandler;
        ReflectionFormBuilder.validateMapping(classMapping, "classMapping");
        ReflectionFormBuilder.validateMapping(primitiveMapping, "primitiveMapping");
        for (Class<?> primitiveMappingKey : primitiveMapping.keySet()) {
            if (primitiveMappingKey.isPrimitive()) continue;
            throw new IllegalArgumentException("primitiveMapping only allows primitive classes as keys");
        }
        this.classMapping.putAll(classMapping);
        this.primitiveMapping = primitiveMapping;
    }

    public Map<Type, FieldHandler<?, ?, ?, ?>> getClassMapping() {
        return Collections.unmodifiableMap(this.classMapping);
    }

    @Override
    protected Pair<JComponent, ComponentHandler<?>> handle0(final Field field, final Object instance, FieldUpdateListener<E> updateListener, R reflectionFormBuilder) throws FieldHandlingException, ResetException {
        FieldHandler fieldHandler = field.getType().isPrimitive() ? this.primitiveMapping.get(field.getType()) : this.retrieveFieldHandler(field.getGenericType(), this.classMapping);
        if (fieldHandler == null) {
            return null;
        }
        JComponent retValue = fieldHandler.handle(field, instance, new FieldUpdateListener<E>(){

            @Override
            public void onUpdate(E event) {
                try {
                    field.set(instance, ((FieldUpdateEvent)event).getNewValue());
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    LOGGER.error("unexpected exception during field update occured", (Throwable)ex);
                    MappingFieldHandler.this.issueHandler.handleUnexpectedException(new ExceptionMessage((Throwable)ex));
                }
            }
        }, reflectionFormBuilder);
        return new ImmutablePair((Object)retValue, (Object)fieldHandler);
    }

    public FieldHandler retrieveFieldHandler(Type fieldType, Map<Type, FieldHandler<?, ?, ?, ?>> classMapping) {
        FieldHandler<?, ?, ?, ?> fieldHandler;
        Type classMappingKey = fieldType;
        if (fieldType instanceof ParameterizedType) {
            classMappingKey = this.retrieveClassMappingBestMatch((ParameterizedType)fieldType);
        }
        if ((fieldHandler = classMapping.get(classMappingKey)) == null && fieldType instanceof ParameterizedType) {
            ParameterizedType fieldParameterizedType = (ParameterizedType)fieldType;
            Type candidate = this.retrieveClassMappingBestMatch(fieldParameterizedType);
            fieldHandler = classMapping.get(candidate);
        }
        return fieldHandler;
    }

    protected Type retrieveClassMappingBestMatch(ParameterizedType fieldParameterizedType) {
        TreeMap<Integer, LinkedList<ParameterizedType>> candidates = new TreeMap<Integer, LinkedList<ParameterizedType>>();
        block0: for (Type mappingType : this.classMapping.keySet()) {
            ParameterizedType mappingParameterizedType;
            if (!(mappingType instanceof ParameterizedType) || !(mappingParameterizedType = (ParameterizedType)mappingType).getRawType().equals(fieldParameterizedType.getRawType())) continue;
            Type[] parameterizedTypeArguments = mappingParameterizedType.getActualTypeArguments();
            Type[] fieldParameterizedTypeArguments = fieldParameterizedType.getActualTypeArguments();
            for (int i = 0; i < Math.min(parameterizedTypeArguments.length, fieldParameterizedTypeArguments.length); ++i) {
                Type parameterizedTypeArgument;
                if (fieldParameterizedTypeArguments[i].equals(AnyType.class)) {
                    throw new IllegalArgumentException(String.format("type %s must only be used to declare placeholders in class mapping, not in classes (was used in field type %s", AnyType.class, fieldParameterizedType));
                }
                Type fieldParameterizedTypeArgument = fieldParameterizedTypeArguments[i];
                if (fieldParameterizedTypeArgument instanceof ParameterizedType) {
                    fieldParameterizedTypeArgument = ((ParameterizedType)fieldParameterizedTypeArgument).getRawType();
                }
                if ((parameterizedTypeArgument = parameterizedTypeArguments[i]) instanceof ParameterizedType) {
                    parameterizedTypeArgument = ((ParameterizedType)parameterizedTypeArgument).getRawType();
                }
                boolean anyTypeMatch = AnyType.class.equals((Object)parameterizedTypeArgument);
                if (!parameterizedTypeArgument.equals(fieldParameterizedTypeArgument) && !anyTypeMatch) continue block0;
                int matchCount = i + 1;
                LinkedList<ParameterizedType> candidateList = (LinkedList<ParameterizedType>)candidates.get(matchCount);
                if (candidateList == null) {
                    candidateList = new LinkedList<ParameterizedType>();
                    candidates.put(matchCount, candidateList);
                }
                candidateList.add(mappingParameterizedType);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        List higestCandidatesList = (List)candidates.get(candidates.lastKey());
        int lowestAnyCount = Integer.MAX_VALUE;
        ParameterizedType lowestAnyCountCandidate = null;
        for (ParameterizedType highestCandidateCandidate : higestCandidatesList) {
            int highestCandidateCandidateAnyCount = this.retrieveAnyCountRecursively(highestCandidateCandidate);
            if (highestCandidateCandidateAnyCount >= lowestAnyCount) continue;
            lowestAnyCount = highestCandidateCandidateAnyCount;
            lowestAnyCountCandidate = highestCandidateCandidate;
        }
        return lowestAnyCountCandidate;
    }

    protected int retrieveAnyCountRecursively(ParameterizedType type) {
        int retValue = 0;
        for (Type typeArgument : type.getActualTypeArguments()) {
            if (AnyType.class.equals((Object)typeArgument)) {
                ++retValue;
            }
            if (!(typeArgument instanceof ParameterizedType)) continue;
            int recRetValue = this.retrieveAnyCountRecursively((ParameterizedType)typeArgument);
            retValue += recRetValue;
        }
        return retValue;
    }
}

