/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LongPrimitiveFieldHandler
implements FieldHandler<Long, FieldUpdateEvent<Long>, ReflectionFormBuilder, JSpinner> {
    private static final LongPrimitiveFieldHandler INSTANCE = new LongPrimitiveFieldHandler();

    public static LongPrimitiveFieldHandler getInstance() {
        return INSTANCE;
    }

    protected LongPrimitiveFieldHandler() {
    }

    @Override
    public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Long>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        long fieldValue;
        try {
            fieldValue = field.getLong(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        final JSpinner retValue = new JSpinner(new SpinnerNumberModel((Number)fieldValue, Long.valueOf(Long.MIN_VALUE), Long.valueOf(Long.MAX_VALUE), (Number)1L));
        retValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Long>((Long)retValue.getValue()));
            }
        });
        return retValue;
    }

    @Override
    public void reset(JSpinner component) {
        component.setValue(0);
    }
}

