/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.LongPanel;
import de.richtercloud.reflection.form.builder.typehandler.LongTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;

public class LongFieldHandler
implements FieldHandler<Long, FieldUpdateEvent<Long>, ReflectionFormBuilder, LongPanel> {
    private static final LongFieldHandler INSTANCE = new LongFieldHandler();
    private final LongTypeHandler longTypeHandler;

    public static LongFieldHandler getInstance() {
        return INSTANCE;
    }

    protected LongFieldHandler() {
        this(LongTypeHandler.getInstance());
    }

    public LongFieldHandler(LongTypeHandler longTypeHandler) {
        this.longTypeHandler = longTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Long>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Long fieldValue;
        try {
            fieldValue = (Long)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.longTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(LongPanel component) {
        component.reset();
    }
}

