/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerPrimitiveFieldHandler
implements FieldHandler<Integer, FieldUpdateEvent<Integer>, ReflectionFormBuilder, JSpinner> {
    private static final IntegerPrimitiveFieldHandler INSTANCE = new IntegerPrimitiveFieldHandler();

    public static IntegerPrimitiveFieldHandler getInstance() {
        return INSTANCE;
    }

    protected IntegerPrimitiveFieldHandler() {
    }

    @Override
    public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Integer>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        int fieldValue;
        try {
            fieldValue = field.getInt(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        JSpinner retValue = new JSpinner(new SpinnerNumberModel(fieldValue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        retValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Integer>((Integer)((JSpinner)e.getSource()).getValue()));
            }
        });
        return retValue;
    }

    @Override
    public void reset(JSpinner component) {
        component.setValue(0);
    }
}

