/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.IntegerPanel;
import de.richtercloud.reflection.form.builder.typehandler.IntegerTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;

public class IntegerFieldHandler
implements FieldHandler<Integer, FieldUpdateEvent<Integer>, ReflectionFormBuilder, IntegerPanel> {
    private static final IntegerFieldHandler INSTANCE = new IntegerFieldHandler();
    private final IntegerTypeHandler integerTypeHandler;

    public static IntegerFieldHandler getInstance() {
        return INSTANCE;
    }

    protected IntegerFieldHandler() {
        this(IntegerTypeHandler.getInstance());
    }

    public IntegerFieldHandler(IntegerTypeHandler integerTypeHandler) {
        this.integerTypeHandler = integerTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Integer>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Integer fieldValue;
        try {
            fieldValue = (Integer)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.integerTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(IntegerPanel component) {
        component.reset();
    }
}

