/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FloatPrimitiveFieldHandler
implements FieldHandler<Float, FieldUpdateEvent<Float>, ReflectionFormBuilder, JSpinner> {
    private static final FloatPrimitiveFieldHandler INSTANCE = new FloatPrimitiveFieldHandler();

    public static FloatPrimitiveFieldHandler getInstance() {
        return INSTANCE;
    }

    protected FloatPrimitiveFieldHandler() {
    }

    @Override
    public JComponent handle(Field field, Object instance, final FieldUpdateListener<FieldUpdateEvent<Float>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        float fieldValue;
        try {
            fieldValue = field.getFloat(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        final JSpinner retValue = new JSpinner(new SpinnerNumberModel(Float.valueOf(fieldValue), Float.valueOf(-10.0f), Float.valueOf(10.0f), Float.valueOf(0.1f)));
        retValue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                updateListener.onUpdate(new FieldUpdateEvent<Float>((Float)retValue.getValue()));
            }
        });
        return retValue;
    }

    @Override
    public void reset(JSpinner component) {
        component.setValue(0);
    }
}

