/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.reflection.form.builder.fieldhandler;

import de.richtercloud.reflection.form.builder.ReflectionFormBuilder;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandler;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldHandlingException;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateEvent;
import de.richtercloud.reflection.form.builder.fieldhandler.FieldUpdateListener;
import de.richtercloud.reflection.form.builder.panels.FloatPanel;
import de.richtercloud.reflection.form.builder.typehandler.FloatTypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.swing.JComponent;

public class FloatFieldHandler
implements FieldHandler<Float, FieldUpdateEvent<Float>, ReflectionFormBuilder, FloatPanel> {
    private static final FloatFieldHandler INSTANCE = new FloatFieldHandler();
    private final FloatTypeHandler floatTypeHandler;

    public static FloatFieldHandler getInstance() {
        return INSTANCE;
    }

    protected FloatFieldHandler() {
        this(FloatTypeHandler.getInstance());
    }

    public FloatFieldHandler(FloatTypeHandler floatTypeHandler) {
        this.floatTypeHandler = floatTypeHandler;
    }

    @Override
    public JComponent handle(Field field, Object instance, FieldUpdateListener<FieldUpdateEvent<Float>> updateListener, ReflectionFormBuilder reflectionFormBuilder) throws FieldHandlingException {
        Float fieldValue;
        try {
            fieldValue = (Float)field.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new FieldHandlingException(ex);
        }
        Class<?> fieldType = field.getType();
        return (JComponent)this.floatTypeHandler.handle((Type)fieldType, fieldValue, field.getName(), field.getDeclaringClass(), updateListener, reflectionFormBuilder).getKey();
    }

    @Override
    public void reset(FloatPanel component) {
        this.floatTypeHandler.reset(component);
    }
}

